/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.dom;

import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.stubs.index.DomElementClassIndex;
import com.intellij.util.xml.stubs.index.DomNamespaceKeyIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Yann C&eacute;bron
 */
public class SpringDomUtils {

  public static void navigate(@Nullable DomElement domElement) {
    if (domElement == null) return;

    final DomElementsNavigationManager navigationManager = DomElementsNavigationManager.getManager(domElement.getManager().getProject());
    navigationManager.getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME).navigate(domElement, true);
  }

  public static boolean isSpringXml(@NotNull XmlFile configFile) {
    return getSpringDomFileElement(configFile) != null;
  }

  @Nullable
  public static DomFileElement<Beans> getSpringDomFileElement(@NotNull XmlFile configFile) {
    return DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, Beans.class);
  }

  public static boolean hasNamespace(DomFileElement domFileElement,
                                     String namespaceKey) {
    return DomNamespaceKeyIndex.getInstance().hasStubElementsWithNamespaceKey(domFileElement, namespaceKey);
  }

  /**
   * @see com.intellij.util.xml.StubbedOccurrence
   */
  public static boolean hasElement(DomFileElement domFileElement,
                                   Class<? extends DomElement> domElementClazz) {
    return DomElementClassIndex.getInstance().hasStubElementsOfType(domFileElement, domElementClazz);
  }
}
