/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringPresentationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider = SpringPresentationProvider.class)
public interface CommonSpringBean extends CommonModelElement {

  @Nullable
  String getBeanName();

  /**
   * Return aliases defined in the bean definition, not including the bean name.
   *
   * @return bean aliases
   * @see com.intellij.spring.contexts.model.SpringModel#getAllBeanNames(String)
   */
  @NotNull
  String[] getAliases();

  @Nullable
  PsiClass getBeanClass(boolean considerFactories);

  @Nullable
  PsiClass getBeanClass();

  @Nullable
  SpringQualifier getSpringQualifier();

  @NotNull
  SpringProfile getProfile();

  boolean isPrimary();
}
