/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiClass;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import org.jetbrains.annotations.NotNull;

/**
 * @since 16
 */
@Presentation(typeName = "@Component")
public abstract class SpringComponent extends SpringStereotypeElement {

  public static final JamClassMeta<SpringComponent> META =
    new JamClassMeta<SpringComponent>(null, SpringComponent.class,
                                      JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.<SpringComponent>subKey("SpringComponent"));

  static {
    addPomTargetProducer(META);
  }

  public SpringComponent(@NotNull PsiClass psiClass) {
    super(SpringAnnotationsConstants.COMPONENT);
  }
}
