/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;

/**
 * Returns {@link com.intellij.spring.model.xml.DomSpringBean#getId()} if set or given fallback name.
 *
 * @param <T> DomSpringBean type.
 * @since 14
 */
public class FallBackBeanNameProvider<T extends DomSpringBean> implements BeanNameProvider<T> {

  private final String myFallBackName;

  protected FallBackBeanNameProvider(String fallBackName) {
    myFallBackName = fallBackName;
  }

  @Nullable
  @Override
  public final String getBeanName(T t) {
    if (DomUtil.hasXml(t.getId())) {
      return t.getId().getRawText();
    }

    return myFallBackName;
  }
}
