/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import org.jetbrains.annotations.NonNls;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Provides type checking for Spring bean DOM reference.
 * <p/>
 * Typical usage:
 * <pre>
 *   &#064;RequiredBeanType("com.expected.BeanType")
 *   &#064;Convert(SpringBeanResolveConverter.class)
 *   GenericAttributeValue<SpringBeanPointer> getBeanRefAttribute();
 * </pre>
 * <p/>
 * Highlighting provided by {@link com.intellij.spring.model.highlighting.dom.RequiredBeanTypeChecker}
 * which is called from dedicated inspection.
 * <p/>
 * NB: in 14, usage as <em>type</em> annotation has been replaced with
 * dedicated {@link com.intellij.spring.model.xml.BeanType}.
 *
 * @see com.intellij.spring.model.converters.SpringBeanResolveConverter
 * @see com.intellij.spring.model.converters.SpringBeanListConverter
 * @see com.intellij.spring.model.converters.SpringConverterUtil#getRequiredBeanTypeClasses(com.intellij.util.xml.ConvertContext)
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface RequiredBeanType {

  /**
   * Possible bean type(s) FQN (usually top-most interface).
   *
   * @return Required base class(es).
   */
  @NonNls String[] value() default "UNDEFINED";
}
