/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/**
 * http://www.springframework.org/schema/beans:autowireAttrType enumeration.
 */
public enum Autowire implements NamedEnum {
  AUTODETECT ("autodetect"),
  BY_NAME ("byName"),
  BY_TYPE ("byType"),
  CONSTRUCTOR ("constructor"),
  DEFAULT ("default"),
  NO ("no");

  private final String value;

  private Autowire(@NonNls String value) { this.value = value; }

  public String getValue() { return value; }

  public boolean isAutowired() { return !equals(DEFAULT) && !equals(NO); }

  public static Autowire fromDefault(@Nullable Autowire defaultAutowire) {
    if (defaultAutowire == null) {
      return DEFAULT;
    }

    switch (defaultAutowire) {
      case BY_NAME:
        return BY_NAME;
      case BY_TYPE:
        return BY_TYPE;
      case CONSTRUCTOR:
        return CONSTRUCTOR;
      case NO:
        return NO;
      default:
        return DEFAULT;
    }
  }
}
