/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.converters.SpringProfileConverter;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Set;

/**
 * @author Sergey Vasiliev
 */
@Convert(SpringProfileConverter.class)
public abstract class SpringDomProfile implements GenericAttributeValue<List<String>>, SpringProfile, CommonModelElement {

  @Override
  public PsiElement getIdentifyingPsiElement() {
    return getXmlElement();
  }

  @NotNull
  @Override
  public Set<String> getNames() {
    Set<String> names = new HashSet<String>();

    final List<String> profileNames = getValue();
    if (profileNames == null) {
      names.add(DEFAULT_PROFILE_NAME);
    }
    else {
      names.addAll(profileNames);
    }

    return names;
  }
}
