---- RetrieveTablesAndViewsInfo ----
select table_name, table_type, table_comment
from information_schema.tables
where table_schema = ?

---- RetrieveIndicesInfo ----
select
  table_name,
  index_name,
  group_concat(column_name order by seq_in_index separator '\n') as column_names,
  non_unique
from information_schema.statistics
where table_schema = ? and
      index_schema = ? and
      index_name <> 'PRIMARY'
group by
  table_catalog,
  table_schema,
  table_name,
  index_name,
  index_type,
  non_unique

---- RetrieveConstraintsInfo ----
select
  c.constraint_name,
  c.table_name,
  c.constraint_type,
  group_concat(u.column_name order by u.ordinal_position separator '\n' ) as column_names,
  u.referenced_table_schema,
  u.referenced_table_name,
  group_concat(u.referenced_column_name order by u.position_in_unique_constraint separator '\n') as ref_column_names
from information_schema.table_constraints c
  left join information_schema.key_column_usage u on
      u.constraint_schema   = c.constraint_schema
  and u.constraint_name     = c.constraint_name
  and u.table_name = c.table_name
  and u.table_schema = ?
  and ((c.constraint_type = 'UNIQUE' and u.referenced_table_name is null) or c.constraint_type <> 'UNIQUE')
where c.table_schema = ?
  and u.table_schema = ?
group by
    c.constraint_schema
  , c.constraint_name
  , c.table_schema
  , c.table_name
  , c.constraint_type
  , u.referenced_table_schema
  , u.referenced_table_name
order by
    c.table_schema
  , c.table_name
  , c.constraint_schema
  , c.constraint_name

---- RetrieveRoutinesInfo ----
select
 specific_name,
 routine_type,
 routine_definition,
 routine_comment,
 dtd_identifier
from information_schema.routines
where routine_schema = ?

---- ParametersTableExists ----
select table_name from information_schema.tables
where table_schema = 'information_schema' and table_name = 'parameters'

---- RetrieveRoutineParamsInfo ----
select specific_name,
parameter_name,
parameter_mode,
dtd_identifier
from information_schema.parameters
where specific_schema = ? and ordinal_position > 0
order by specific_name, ordinal_position

---- RetrieveTableColumnsInfo ----
select
column_name,
column_type,
column_default,
table_name,
column_comment,
is_nullable,
extra
from information_schema.columns
where table_schema = ?
order by table_name, ordinal_position

---- RetrieveViewsInfo ----
select table_name, view_definition, view_comment
from information_schema.views
where table_schema = ?

---- RetrieveTriggersInfo ----
select
trigger_name,
event_object_table,
action_statement,
event_manipulation,
action_timing
from information_schema.triggers
where trigger_schema = ?