/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.extractors;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.extensions.Binding;
import com.intellij.database.model.DasTable;

import java.util.List;

public interface ExtractorScriptBindings {
  Binding<DatabaseDialect>            DATABASE_DIALECT = new Binding<DatabaseDialect>("DIALECT");
  Binding<DasTable>                     DATABASE_TABLE = new Binding<DasTable>("TABLE");
  Binding<List<? extends DataColumn>>      ALL_COLUMNS = new Binding<List<? extends DataColumn>>("ALL_COLUMNS");
  Binding<List<? extends DataColumn>> SELECTED_COLUMNS = new Binding<List<? extends DataColumn>>("COLUMNS");
  Binding<ValueFormatter>                    FORMATTER = new Binding<ValueFormatter>("FORMATTER");
  Binding<Appendable>                           OUTPUT = new Binding<Appendable>("OUT");
  Binding<DataStream>                            INPUT = new Binding<DataStream>("ROWS");
  Binding<Boolean>                          TRANSPOSED = new Binding<Boolean>("TRANSPOSED");
}
