/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.model;

import java.util.Locale;

/**
 * Kind o database object.
 * @author Leonid Bushuev from JetBrains
 */
public class ObjectKind {

  public static final ObjectKind NONE = new ObjectKind("NONE");
  public static final ObjectKind DATABASE = new ObjectKind("DATABASE");
  public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA");
  public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE");
  public static final ObjectKind TABLE = new ObjectKind("TABLE");
  public static final ObjectKind COLUMN = new ObjectKind("COLUMN");
  public static final ObjectKind INDEX = new ObjectKind("INDEX");
  public static final ObjectKind KEY = new ObjectKind("KEY");
  public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY");
  public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER");
  public static final ObjectKind VIEW = new ObjectKind("VIEW");
  public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW");
  public static final ObjectKind CHECK = new ObjectKind("CHECK");
  public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER");
  public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE");
  public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE");
  public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE");
  public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE");
  public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE");
  public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE");
  public static final ObjectKind BODY = new ObjectKind("BODY");
  public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE");
  public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT");
  public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR");
  public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE");
  public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM");
  public static final ObjectKind DB_LINK = new ObjectKind("DBLINK");
  public static final ObjectKind COMMENT = new ObjectKind("COMMENT");
  public static final ObjectKind DOMESTIC_COLUMN_REF = new ObjectKind("DOMESTIC COLUMN REF");
  public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT");

  private final String myName;

  public ObjectKind(String name) {
    this.myName = name;
  }

  public String name() {
    return myName;
  }

  /**
   * Returns the formal code, that can be used to write it into a file.
   * This code also XML-friendly, starts with a letter and can contain
   * letters, digits and dashes.
   * @return the formal code.
   * @see MetaModel#findKind(String)
   */
  public String code() {
    return myName.toLowerCase(Locale.ENGLISH).replace(' ','-');
  }


  @Override
  public String toString() {
    return code();
  }

}
