/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.psi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.SimpleModificationTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author Gregory.Shrago
 */
public abstract class DbPsiFacade extends SimpleModificationTracker {

  public static DbPsiFacade getInstance(@NotNull Project project) {
    return ServiceManager.getService(project, DbPsiFacade.class);
  }

  public abstract Project getProject();

  public abstract List<DbPsiManager> getDbManagers();

  @NotNull
  public abstract List<DbDataSource> getDataSources();
  
  @Nullable
  public abstract DbDataSource findDataSource(final String id);

  public abstract void addModificationTrackerListener(final ModificationTrackerListener<DbPsiFacade> listener, final Disposable parent);

  public abstract void clearCaches(@Nullable DbDataSource selectedElement);
}
