package com.intellij.sql.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.Set;

/**
 * @author Gregory.Shrago
 */
public abstract class SqlLanguageDialect extends Language {

  public SqlLanguageDialect(@NonNls @NotNull String id) {
    super(SqlLanguage.getInstance(), id);
  }

  @NotNull
  public abstract DatabaseDialect getDatabaseDialect();

  public abstract boolean isReservedKeyword(IElementType tokenType);

  public boolean isReservedKeywordPL(IElementType tokenType) {
    return isReservedKeyword(tokenType);
  }

  public abstract boolean isOperatorSupported(IElementType tokenType);

  @NotNull
  public abstract Set<String> getKeywords();

  @NotNull
  public abstract Set<String> getSystemVariables();

  @NotNull
  public Set<String> getExceptionNames() {
    return Collections.emptySet();
  }

  public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, @Nullable PsiElement place) {
    ObjectKind type = dbElement.getKind();
    if (type != ObjectKind.DATABASE && type != ObjectKind.SCHEMA) return false;
    if (StringUtil.isEmpty(dbElement.getName())) return true;
    DatabaseFamilyId familyId = getDatabaseDialect().getFamilyId();
    return !familyId.isMicrosoft() && type == ObjectKind.DATABASE;
  }

  public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
    return false;
  }

  public abstract TokenSet getStatementSeparators();
}
