package com.intellij.sql.psi;

import com.intellij.database.model.DasForeignKey;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;

/**
 * @author Gregory.Shrago
 */
public interface SqlForeignKeyDefinition extends SqlDefinition, DasForeignKey {
  SqlForeignKeyDefinition[] EMPTY_ARRAY = new SqlForeignKeyDefinition[0];
  ArrayFactory<SqlForeignKeyDefinition> ARRAY_FACTORY = new ArrayFactory<SqlForeignKeyDefinition>() {
    @NotNull
    @Override
    public SqlForeignKeyDefinition[] create(int count) {
      return count == 0 ? EMPTY_ARRAY : new SqlForeignKeyDefinition[count];
    }
  };
}