/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Producer;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDuplicatesProfile
extends DuplicatesProfileBase {
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/JSDuplicatesProfile", "isMyLanguage"));
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public PsiElementRole getRole(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JSDuplicatesProfile", "getRole"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSVariable && ((JSVariable)parent).getNameIdentifier() == element) {
            return PsiElementRole.VARIABLE_NAME;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == element) {
            return PsiElementRole.FUNCTION_NAME;
        }
        return null;
    }

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/JSDuplicatesProfile", "createVisitor"));
        }
        NodeSpecificHasherBase nodeSpecificHasherBase = new NodeSpecificHasherBase(DuplocatorSettings.getInstance(), collector, this, forIndexing){

            public int getNodeHash(PsiElement node) {
                if (this.myForIndexing) {
                    if (node instanceof LeafPsiElement) {
                        return 0;
                    }
                    if (node instanceof JSReferenceExpression) {
                        String name;
                        PsiElement parent = node.getParent();
                        if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node) {
                            String name2 = ((JSReferenceExpression)node).getReferencedName();
                            if (name2 != null) {
                                return name2.hashCode();
                            }
                        } else if (((JSReferenceExpression)node).getQualifier() instanceof JSReferenceExpression && (name = ((JSReferenceExpression)node).getReferencedName()) != null) {
                            return name.hashCode();
                        }
                        return 0;
                    }
                    if (node instanceof JSVariable) {
                        return 0;
                    }
                }
                return super.getNodeHash(node);
            }
        };
        if (nodeSpecificHasherBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JSDuplicatesProfile", "createVisitor"));
        }
        return nodeSpecificHasherBase;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JSDuplicatesProfile", "getLanguage"));
        }
        Language language = JSDuplicatesProfile.getLanguageForElement(element);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JSDuplicatesProfile", "getLanguage"));
        }
        return language;
    }

    public int getNodeCost(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JSDuplicatesProfile", "getNodeCost"));
        }
        if (element instanceof JSStatement || element instanceof JSFunction || element instanceof JSClass) {
            return 2;
        }
        if (element instanceof JSExpression) {
            return 1;
        }
        return 0;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        PsiElement[] elements = fragment.getElements();
        if (elements.length == 0) {
            return false;
        }
        return JSDuplicatesProfile.isAcceptableElement(elements[0]);
    }

    private static boolean isAcceptableElement(PsiElement element) {
        if (element instanceof JSStatement) {
            if (element instanceof JSBlockStatement) {
                ASTNode node = element.getNode();
                ASTNode firstStatement = node.findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
                if (firstStatement == null) {
                    return false;
                }
                for (ASTNode last = node.getLastChildNode(); last != null; last = last.getTreePrev()) {
                    if (!JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(last.getElementType())) continue;
                    if (last != firstStatement) break;
                    return JSDuplicatesProfile.isAcceptableElement(last.getPsi());
                }
                if (element.getParent() instanceof JSFunction) {
                    return false;
                }
            }
            if (!(element instanceof JSExpressionStatement || element instanceof JSLabeledStatement || element instanceof JSContinueStatement || element instanceof JSBreakStatement || element instanceof JSVarStatement || element instanceof JSReturnStatement)) {
                return true;
            }
        }
        if (element instanceof JSExpression && element.getParent() instanceof JSExpressionStatement && !(element instanceof JSAssignmentExpression)) {
            return true;
        }
        return element instanceof JSFunction;
    }

    public TokenSet getLiterals() {
        return JSTokenTypes.LITERALS;
    }

    public static Language getLanguageForElement(PsiElement element) {
        return DialectDetector.languageOfElement(element);
    }

    public boolean supportDuplicatesIndex() {
        return true;
    }

    public boolean acceptsContentForIndexing(final FileContent fileContent) {
        return !JSMinifiedFileUtil.isFileContentMinified(fileContent.getFileName(), new Producer<CharSequence>(){

            @Nullable
            public CharSequence produce() {
                return fileContent.getContentAsText();
            }
        });
    }
}

