/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class JSModuleReference
extends FileReference
implements JSModuleBaseReference {
    public static final String[] IMPLICIT_EXTENSIONS = new String[]{".coffee", ".d.ts", ".d.tsx", ".ts", ".tsx", ".js", ".jsx", ".es6"};
    public static final String PACKAGE_JSON = "package.json";
    private final String[] myImplicitExtensions;

    public JSModuleReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSModuleReference", "<init>"));
        }
        this(text, offset, textRange, fileReferenceSet, IMPLICIT_EXTENSIONS);
    }

    public JSModuleReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSModuleReference", "<init>"));
        }
        super(fileReferenceSet, textRange, offset, text);
        this.myImplicitExtensions = implicitExtensions;
    }

    public static VirtualFile calcRoot(VirtualFile curdir) {
        while (curdir != null && curdir.findChild(PACKAGE_JSON) == null) {
            curdir = curdir.getParent();
        }
        if (curdir != null) {
            return curdir.getParent();
        }
        return null;
    }

    protected void innerResolveInContext(@NotNull String s, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javascript/JSModuleReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSModuleReference", "innerResolveInContext"));
        }
        int size = results.size();
        boolean lastRef = this.isLast();
        if (!lastRef) {
            super.innerResolveInContext(s, context, results, caseSensitive);
            return;
        }
        if (s.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed()) {
            super.innerResolveInContext(s, context, results, caseSensitive);
            return;
        }
        String text = this.getText();
        for (String extension : this.myImplicitExtensions) {
            if (size != results.size() || !s.endsWith(text) || text.endsWith(extension)) continue;
            super.innerResolveInContext(text + extension, context, results, caseSensitive);
        }
        if (size == results.size()) {
            super.innerResolveInContext(s, context, results, caseSensitive);
            Iterator<ResolveResult> iterator = results.iterator();
            while (iterator.hasNext() && size > 0) {
                iterator.next();
                --size;
            }
            if (!this.isAllowFolders()) {
                while (iterator.hasNext()) {
                    ResolveResult result = iterator.next();
                    if (!(result.getElement() instanceof PsiDirectory)) continue;
                    iterator.remove();
                }
            }
        }
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSModuleReference", "getFileNameToCreate"));
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSModuleReference", "getFileNameToCreate"));
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        FileReference reference;
        String refText;
        if (!this.isLast()) {
            return super.rename(newName);
        }
        newName = this.fixExtension(newName);
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (reference = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !newName.startsWith("..")) {
            newName = "./" + newName;
        }
        return super.rename(newName);
    }

    private String fixExtension(String newName) {
        String text = this.getText();
        if (text.indexOf(46) == -1) {
            int index = newName.lastIndexOf(46);
            if (index > 0) {
                for (String extension : IMPLICIT_EXTENSIONS) {
                    if (!newName.endsWith(extension)) continue;
                    index = newName.lastIndexOf(extension);
                    break;
                }
            }
            if (index != -1) {
                newName = newName.substring(0, index);
            }
        }
        return newName;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSModuleReference", "bindToElement"));
        }
        if (!this.isRelativeCommonPath() && JSModuleReference.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        return super.bindToElement(element, absolute);
    }

    private boolean isRelativeCommonPath() {
        String path = this.getFileReferenceSet().getPathString();
        return path.startsWith(".");
    }

    private static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSModuleReference", "checkReferencedFileFromNodeModules"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && JSLibraryUtil.hasDirectoryInPath(file, new String[]{"node_modules"}, null);
    }
}

