/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.documentation.HtmlDocumentationProvider;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSSupportLoader
implements ApplicationComponent {
    private static volatile LanguageFileType JS_FILE_TYPE;

    public static void initJSTestSupport() {
        JS_FILE_TYPE = StdFileTypes.JS;
        JSSupportLoader.doApplicationLevelInitialization();
    }

    private static synchronized void doApplicationLevelInitialization() {
        SyntaxHighlighter syntaxHighlighterFromFactory = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)JS_FILE_TYPE, null, null);
        if (syntaxHighlighterFromFactory instanceof JSHighlighter) {
            JSHighlighter highlighter = (JSHighlighter)syntaxHighlighterFromFactory;
            Map<IElementType, TextAttributesKey> keys = highlighter.getKeys1();
            Map<IElementType, TextAttributesKey> keys2 = highlighter.getKeys2();
            HtmlFileHighlighter.registerEmbeddedTokenAttributes(keys, keys2);
            XmlFileHighlighter.registerEmbeddedTokenAttributes(keys, keys2);
            IElementType[] javaDocMarkup = JSSupportLoader.getDocMarkup1();
            IElementType[] javaDocMarkup2 = JSSupportLoader.getDocMarkup2();
            JSHighlighter.registerHtmlMarkup(javaDocMarkup, javaDocMarkup2);
        }
        JSDocumentationProvider jsDocumentationProvider = new JSDocumentationProvider();
        HtmlDocumentationProvider.registerScriptDocumentationProvider((DocumentationProvider)jsDocumentationProvider);
    }

    public static IElementType[] getDocMarkup2() {
        return new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.TAG_WHITE_SPACE};
    }

    public static IElementType[] getDocMarkup1() {
        return new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_NAME, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_EQ};
    }

    @NotNull
    public String getComponentName() {
        if ("JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSSupportLoader", "getComponentName"));
        }
        return "JavaScript";
    }

    public void initComponent() {
        FileType[] registeredFileTypes;
        for (FileType registeredFileType : registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(registeredFileType instanceof JavaScriptFileType)) continue;
            JS_FILE_TYPE = (LanguageFileType)registeredFileType;
            JSSupportLoader.doApplicationLevelInitialization();
            break;
        }
    }

    public void disposeComponent() {
    }

    public static LanguageFileType getJsFileType() {
        return JS_FILE_TYPE;
    }

    @NotNull
    public static JSSupportLoader getInstance() {
        JSSupportLoader jSSupportLoader = (JSSupportLoader)ApplicationManager.getApplication().getComponent(JSSupportLoader.class);
        if (jSSupportLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSSupportLoader", "getInstance"));
        }
        return jSSupportLoader;
    }
}

