/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FlowCompletionContributor
extends CompletionContributor {
    private static final Key<Boolean> DISABLED = Key.create((String)"flow.disabled");
    private static final Logger LOG = Logger.getInstance(FlowCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, final @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javascript/flow/FlowCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/javascript/flow/FlowCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile originalFile = parameters.getOriginalFile();
        if (FlowCompletionContributor.flowDisabled(originalFile)) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        File flow = PathEnvironmentVariableUtil.findInPath((String)"flow");
        if (flow == null) {
            FlowCompletionContributor.disableFlow(originalFile);
            return;
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{flow.getPath()});
        cmd.addParameters(new String[]{"autocomplete", "--json"});
        int line = document.getLineNumber(parameters.getOffset());
        cmd.addParameter(String.valueOf(line + 1));
        cmd.addParameter(String.valueOf(parameters.getOffset() - document.getLineStartOffset(line) + 1));
        cmd.setWorkDirectory(originalFile.getContainingDirectory().getVirtualFile().getPath());
        final HashMap<String, String> names = new HashMap<String, String>();
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(cmd);
            ProcessOutput output = handler.runProcess();
            Process process = handler.getProcess();
            process.getOutputStream().write(document.getText().getBytes(CharsetToolkit.UTF8_CHARSET));
            process.getOutputStream().close();
            if (!StringUtil.isEmpty((String)output.getStderr())) {
                FlowCompletionContributor.disableFlow(originalFile);
                LOG.info(output.getStderr());
                return;
            }
            JsonElement parse = new JsonParser().parse(output.getStdout());
            if (parse instanceof JsonArray) {
                for (JsonElement e : (JsonArray)parse) {
                    if (!(e instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)e;
                    names.put(object.get("name").getAsString(), object.get("type").getAsString());
                }
            }
        }
        catch (Throwable e) {
            LOG.info(e);
            FlowCompletionContributor.disableFlow(originalFile);
            return;
        }
        resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult result) {
                LookupElement element = result.getLookupElement();
                String type = (String)names.remove(element.getLookupString());
                if (type != null && element instanceof MutableLookupElement) {
                    ((MutableLookupElement)element).setBold();
                    ((MutableLookupElement)element).setPriority(100.0);
                }
                resultSet.passResult(result);
            }
        });
        for (Map.Entry entry : names.entrySet()) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)((String)entry.getKey())).appendTailText((String)entry.getValue(), false).bold());
        }
    }

    private static boolean flowDisabled(PsiFile file) {
        return System.getProperty("flow.enabled") == null || file.getUserData(DISABLED) == Boolean.TRUE;
    }

    private static void disableFlow(PsiFile file) {
        file.putUserData(DISABLED, (Object)true);
    }
}

