/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInterpretersView {
    public static final Comparator<Pair<String, SemVer>> COMPARATOR = new Comparator<Pair<String, SemVer>>(){

        @Override
        public int compare(Pair<String, SemVer> o1, Pair<String, SemVer> o2) {
            int versionsCompare = ((SemVer)o2.getSecond()).compareTo((SemVer)o1.getSecond());
            if (versionsCompare != 0) {
                return versionsCompare;
            }
            return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
        }
    };
    private final Project myProject;
    private final boolean myAllowRemoteSelection;
    private TableView myTable;
    private ToolbarDecorator myDecorator;
    private JPanel myMain;

    public NodeInterpretersView(Project project, boolean allowRemoteSelection) {
        this.myProject = project;
        this.myAllowRemoteSelection = allowRemoteSelection;
        this.initUI();
    }

    @Nullable
    public static Pair<String, SemVer> configureAndSelect(@Nullable Project project, boolean allowRemoteSelection, @Nullable String initialValue) {
        NodeInterpretersView view = new NodeInterpretersView(project, allowRemoteSelection);
        view.resetAndSelectNew(initialValue);
        DialogBuilder builder = new DialogBuilder();
        builder.setTitle("Configure Node.js Interpreters");
        builder.setCenterPanel((JComponent)view.getComponent());
        builder.setDimensionServiceKey(NodeInterpretersView.class.getName());
        builder.setPreferredFocusComponent(view.getPreferredFocusComponent());
        if (builder.showAndGet()) {
            Pair<String, SemVer> selected = view.getSelected();
            if (selected != null && !allowRemoteSelection && NodeLocalVersionsManager.isRemote(StringUtil.notNullize((String)((String)selected.getFirst())))) {
                return null;
            }
            return selected;
        }
        return null;
    }

    public JComponent getPreferredFocusComponent() {
        return this.myTable;
    }

    @Nullable
    public Pair<String, SemVer> getSelected() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (Pair)this.getTableModelModel().getRowValue(row);
    }

    private void initUI() {
        final NodeJSRemoteInterpreterManager remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();
        this.myTable = new TableView(new ListTableModel(NodeInterpretersView.getColumnInfos()));
        this.myTable.getEmptyText().setText("Add Node.js interpreter with the + button");
        new TableSpeedSearch((JTable)this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        TableColumn versionColumn = this.myTable.getColumnModel().getColumn(1);
        String header = versionColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = Math.max(fm.stringWidth(header + "ww"), fm.stringWidth("v01.10.10"));
        TableUtil.setupCheckboxColumn((TableColumn)versionColumn, (int)width);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (!NodeInterpretersView.this.myAllowRemoteSelection || remoteInterpreterManager == null) {
                    NodeInterpretersView.this.resetAndSelectNew(NodeInterpretersView.this.addLocal());
                    return;
                }
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new DumbAwareAction("Add Local"){

                    public void actionPerformed(AnActionEvent e) {
                        NodeInterpretersView.this.resetAndSelectNew(NodeInterpretersView.this.addLocal());
                    }
                });
                group.add((AnAction)new DumbAwareAction("Add Remote"){

                    public void actionPerformed(AnActionEvent e) {
                        NodeInterpretersView.this.resetAndSelectNew(NodeInterpretersView.this.addRemote(remoteInterpreterManager));
                    }
                });
                ListPopup popup = PopupFactoryImpl.getInstance().createActionGroupPopup(null, (ActionGroup)group, button.getDataContext(), false, true, true, null, -1, null);
                RelativePoint point = button.getPreferredPopupPoint();
                if (point != null) {
                    popup.show(point);
                } else {
                    popup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                NodeInterpretersView.this.editLine(remoteInterpreterManager);
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                int row = NodeInterpretersView.this.myTable.getSelectedRow();
                if (row < 0) {
                    return false;
                }
                Pair item = (Pair)NodeInterpretersView.this.getTableModelModel().getItem(row);
                return NodeLocalVersionsManager.isRemote((String)item.getFirst());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int row = NodeInterpretersView.this.myTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                Pair item = (Pair)NodeInterpretersView.this.getTableModelModel().getItem(row);
                if (NodeLocalVersionsManager.isRemote((String)item.getFirst())) {
                    NodeJSRemoteInterpreterManager remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Delete Remote Interpreter");
                    if (remoteInterpreterManager == null) {
                        return;
                    }
                    remoteInterpreterManager.deleteRemoteInterpreter((String)item.getFirst());
                } else {
                    NodeLocalVersionsManager.getInstance().deleteInterpreter((String)item.getFirst());
                }
                NodeInterpretersView.this.resetAndSelectNew(null);
            }
        }).disableUpAction().disableDownAction();
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    NodeInterpretersView.this.editLine(remoteInterpreterManager);
                }
            }
        });
        JPanel panel = this.myDecorator.createPanel();
        this.myMain = new JPanel(new BorderLayout());
        this.myMain.add((Component)panel, "Center");
    }

    private void editLine(NodeJSRemoteInterpreterManager remoteInterpreterManager) {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        Pair item = (Pair)this.getTableModelModel().getItem(row);
        if (NodeLocalVersionsManager.isRemote((String)item.getFirst()) && remoteInterpreterManager != null) {
            String createdId = remoteInterpreterManager.editRemoteInterpreter(this.myProject, (String)item.getFirst());
            if (createdId == null) {
                return;
            }
            this.resetAndSelectNew(createdId);
        }
    }

    private String addRemote(NodeJSRemoteInterpreterManager remoteInterpreterManager) {
        String id = remoteInterpreterManager.createRemoteInterpreter(this.myProject);
        if (id == null) {
            return null;
        }
        return id;
    }

    private String addLocal() {
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (Project)this.myProject, null);
        if (file == null) {
            return null;
        }
        NodeLocalVersionsManager manager = NodeLocalVersionsManager.getInstance();
        manager.addInterpreterPath(file.getPath());
        manager.getVersionAsync(new File(file.getPath()), new Consumer<SemVer>(){

            public void consume(SemVer ver) {
                NodeInterpretersView.this.resetInAwt();
            }
        });
        return file.getPath();
    }

    private void resetInAwt() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                NodeInterpretersView.this.resetAndSelectNew(null);
            }
        });
    }

    private void resetAndSelectNew(@Nullable String newPath) {
        String pathToSelect = null;
        if (newPath == null) {
            int row = this.myTable.getSelectedRow();
            if (row >= 0) {
                pathToSelect = (String)((Pair)this.getTableModelModel().getItem(row)).getFirst();
            }
        } else {
            pathToSelect = newPath;
        }
        this.reset();
        ListTableModel<Pair<String, SemVer>> model = this.getTableModelModel();
        if (model.getRowCount() == 0) {
            return;
        }
        if (pathToSelect != null) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!Comparing.equal((String)((String)((Pair)model.getItem(i)).getFirst()), (String)pathToSelect)) continue;
                this.myTable.addRowSelectionInterval(i, i);
                return;
            }
        }
        this.myTable.addRowSelectionInterval(0, 0);
    }

    public JPanel getComponent() {
        return this.myMain;
    }

    public void reset() {
        List<Pair<String, SemVer>> list = this.loadInterpretersData();
        this.getTableModelModel().setItems(list);
        this.getTableModelModel().fireTableDataChanged();
    }

    public boolean isModified() {
        List items;
        List<Pair<String, SemVer>> list = this.loadInterpretersData();
        return !Comparing.equal(list, (Object)(items = this.getTableModelModel().getItems()));
    }

    private ListTableModel<Pair<String, SemVer>> getTableModelModel() {
        return (ListTableModel)this.myTable.getModel();
    }

    private List<Pair<String, SemVer>> loadInterpretersData() {
        NodeJSRemoteInterpreterManager remoteInterpreterManager;
        ArrayList<Pair<String, SemVer>> result;
        List<Pair<String, NodeLocalVersionsManager.VersionData>> localVersions = NodeLocalVersionsManager.getInstance().getVersions();
        List<Object> list = result = localVersions.isEmpty() ? new ArrayList<Pair<String, SemVer>>() : ContainerUtil.map(localVersions, (Function)new NotNullFunction<Pair<String, NodeLocalVersionsManager.VersionData>, Pair<String, SemVer>>(){

            @NotNull
            public Pair<String, SemVer> fun(Pair<String, NodeLocalVersionsManager.VersionData> dom) {
                Pair pair = Pair.create((Object)FileUtil.toSystemDependentName((String)((String)dom.getFirst())), (Object)((NodeLocalVersionsManager.VersionData)dom.getSecond()).getVer());
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeInterpretersView$9", "fun"));
                }
                return pair;
            }
        });
        if (this.myAllowRemoteSelection && (remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance()) != null) {
            List<Pair<String, SemVer>> interpreters = remoteInterpreterManager.getRemoteInterpretersWithVersions();
            result.addAll(interpreters);
        }
        Collections.sort(result, COMPARATOR);
        return result;
    }

    private static ColumnInfo[] getColumnInfos() {
        return new ColumnInfo[]{new ColumnInfo<Pair<String, SemVer>, String>("Path"){

            @Nullable
            public String valueOf(Pair<String, SemVer> pair) {
                return (String)pair.getFirst();
            }
        }, new ColumnInfo<Pair<String, SemVer>, String>("Version"){

            @Nullable
            public String valueOf(Pair<String, SemVer> pair) {
                return ((SemVer)pair.getSecond()).getRawVersion();
            }
        }};
    }
}

