/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpretersDialog
extends DialogWrapper {
    private static final String DIMENSION_SERVICE_KEY = "jetbrains.nodejs.interpreters-dialog";
    private static final String SPLITTER_KEY = "jetbrains.nodejs.interpreters-dialog";
    private static final String HELP_ID = "jetbrains.nodejs.interpreters-dialog.helpId";
    private final Project myProject;
    private final DefaultListModel<NodeJsInterpreter> myListModel;
    private final JBList myList;
    private final boolean myEnableRemote;
    private final EditInterpreterView myEditView;
    private final JComponent myCenterPanelComponent;
    private final boolean myProjectDefaultField;
    private NodeJsInterpreter myProjectDefaultInterpreter;
    private boolean myProjectDefaultInterpreterChanged;

    public NodeJsInterpretersDialog(@NotNull Project project, final boolean projectDefaultField, boolean enableRemote) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "<init>"));
        }
        super(project, true);
        this.myProjectDefaultInterpreterChanged = false;
        this.myProject = project;
        this.myEnableRemote = enableRemote;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setSelectionMode(0);
        this.myList.getEmptyText().setText(NodeJsInterpretersDialog.getEmptyText());
        this.myProjectDefaultField = projectDefaultField;
        if (!projectDefaultField) {
            this.myProjectDefaultInterpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        }
        this.myList.setCellRenderer((ListCellRenderer)new NodeJsInterpreterRenderer(false, new Predicate<NodeJsInterpreter>(){

            public boolean apply(@Nullable NodeJsInterpreter input) {
                if (input == null || projectDefaultField) {
                    return false;
                }
                return input.equals(NodeJsInterpretersDialog.this.myProjectDefaultInterpreter);
            }
        }));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                NodeJsInterpretersDialog.this.performAddAction(button);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                NodeJsInterpretersDialog.this.removeSelected();
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return NodeJsInterpretersDialog.this.myList.getSelectedIndex() >= 0;
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                NodeJsInterpretersDialog.this.editSelectedIfInplaceEditorUnavailable();
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return NodeJsInterpretersDialog.this.isInplaceEditorUnavailable();
            }
        }).disableUpDownActions();
        JPanel decoratorPanel = decorator.createPanel();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$7", "onClick"));
                }
                if (event.getButton() == 1 && clickCount == 2 && NodeJsInterpretersDialog.this.isInplaceEditorUnavailable()) {
                    NodeJsInterpretersDialog.this.editSelectedIfInplaceEditorUnavailable();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myList);
        decoratorPanel.setPreferredSize(new Dimension(JBUI.scale((int)550), JBUI.scale((int)300)));
        JScrollPane pane = JBScrollPane.findScrollPane((Component)this.myList);
        if (pane != null) {
            pane.setHorizontalScrollBarPolicy(31);
        }
        this.myEditView = new EditInterpreterView();
        JBSplitter splitter = new JBSplitter("jetbrains.nodejs.interpreters-dialog", 0.7f);
        splitter.setOrientation(true);
        splitter.setFirstComponent((JComponent)decoratorPanel);
        splitter.setSecondComponent((JComponent)this.myEditView.getPanel());
        this.myCenterPanelComponent = splitter;
        this.setTitle("Node.js Interpreters");
        this.init();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                NodeJsInterpreter selected = NodeJsInterpretersDialog.this.getSelectedInterpreter();
                NodeJsInterpretersDialog.this.myEditView.edit(selected);
            }
        });
        this.configurePopupHandler();
        this.addInterpreters();
    }

    private void configurePopupHandler() {
        ArrayList actionList = ContainerUtil.newArrayList((Object[])new AnAction[]{new SetAsProjectInterpreterAction()});
        DefaultActionGroup actionGroup = new DefaultActionGroup((List)actionList);
        for (AnAction action : actionList) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, (JComponent)this.myList);
        }
        PopupHandler.installPopupHandler((JComponent)this.myList, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = NodeJsInterpretersDialog.this.myList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    NodeJsInterpretersDialog.this.myList.setSelectedIndex(index);
                }
            }
        });
    }

    @Nullable
    private NodeJsInterpreter getSelectedInterpreter() {
        return NodeJsInterpreter.tryCast(this.myList.getSelectedValue());
    }

    private boolean isInplaceEditorUnavailable() {
        NodeJsInterpreter interpreter = this.getSelectedInterpreter();
        return interpreter != null && !interpreter.getType().isInplaceEditorAvailable();
    }

    private void editSelectedIfInplaceEditorUnavailable() {
        NodeJsInterpreter newInterpreter;
        NodeJsInterpreterType<? extends NodeJsInterpreter> interpreterType;
        NodeJsInterpreter interpreter;
        int selectedInd = this.myList.getSelectedIndex();
        if (selectedInd >= 0 && (interpreter = NodeJsInterpreter.tryCast(this.myListModel.getElementAt(selectedInd))) != null && !(interpreterType = interpreter.getType()).isInplaceEditorAvailable() && (newInterpreter = interpreterType.edit(this.myProject, interpreter)) != null) {
            this.myListModel.setElementAt(newInterpreter, selectedInd);
        }
    }

    private void removeSelected() {
        int[] selected = this.myList.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        Arrays.sort(selected);
        for (int selectedInd : selected = ArrayUtil.reverseArray((int[])selected)) {
            this.myListModel.removeElementAt(selectedInd);
        }
        int selectInd = selected[0] - selected.length + 1;
        if (0 <= selectInd && selectInd < this.myListModel.size()) {
            this.myList.setSelectedIndex(selectInd);
        }
    }

    private void addInterpreters() {
        List<NodeJsInterpreterType> types = this.enabledTypes();
        for (NodeJsInterpreterType type : types) {
            List interpreters = type.getInterpreters();
            for (NodeJsInterpreter interpreter : interpreters) {
                this.myListModel.addElement(interpreter);
            }
        }
    }

    @NotNull
    private static String getEmptyText() {
        Shortcut shortcut;
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        if (shortcutSet != null && (shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts())) != null) {
            String string = "Add interpreter with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "getEmptyText"));
            }
            return string;
        }
        if ("No interpreters added" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "getEmptyText"));
        }
        return "No interpreters added";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "getStyle"));
        }
        return dialogStyle;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "jetbrains.nodejs.interpreters-dialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanelComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    @NotNull
    private List<NodeJsInterpreterType> enabledTypes() {
        List<NodeJsInterpreterType> list = NodeJsInterpretersDialog.enabledTypes(this.myEnableRemote);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "enabledTypes"));
        }
        return list;
    }

    @NotNull
    static List<NodeJsInterpreterType> enabledTypes(boolean enableRemote) {
        ArrayList enabledTypes = ContainerUtil.newArrayList();
        if (enableRemote) {
            enabledTypes.add(NodeJsRemoteInterpreterType.getInstance());
        }
        enabledTypes.add(NodeJsLocalInterpreterType.getInstance());
        ArrayList arrayList = enabledTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "enabledTypes"));
        }
        return arrayList;
    }

    private int findInterpreterIndex(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "findInterpreterIndex"));
        }
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            if (!interpreter.equals(this.myListModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void performAddAction(@NotNull AnActionButton button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "performAddAction"));
        }
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myProject, this.enabledTypes(), button.getDataContext(), new Consumer<NodeJsInterpreter>(){

            public void consume(@NotNull NodeJsInterpreter interpreter) {
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$10", "consume"));
                }
                NodeJsInterpretersDialog.this.addIfNeededAndSelect(interpreter);
            }
        });
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup.show(point);
        } else {
            popup.showInBestPositionFor(button.getDataContext());
        }
    }

    @NotNull
    public static JBPopup createAddPopup(@NotNull Project project, @NotNull List<NodeJsInterpreterType> types, @NotNull DataContext dataContext, @NotNull Consumer<NodeJsInterpreter> callback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "createAddPopup"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "createAddPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "createAddPopup"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "createAddPopup"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (NodeJsInterpreterType type : types) {
            group.add((AnAction)new AddInterpreterTypeAction(project, type, callback));
        }
        for (NodeJsInterpreterType type : types) {
            List interpreters = type.getInterpretersSuggestedToAdd();
            for (NodeJsInterpreter interpreter : interpreters) {
                group.add((AnAction)new AddInterpreterAction(interpreter, callback));
            }
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, true, null, -1, null);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "createAddPopup"));
        }
        return listPopup;
    }

    protected void doOKAction() {
        this.myEditView.apply();
        super.doOKAction();
    }

    @NotNull
    public Pair<Boolean, NodeJsInterpreter> showAndGetSelected(@Nullable NodeJsInterpreter selected) {
        if (selected != null) {
            this.addIfNeededAndSelect(selected);
        } else {
            this.myList.clearSelection();
        }
        if (this.showAndGet()) {
            if (!this.myProjectDefaultField && this.myProjectDefaultInterpreterChanged) {
                NodeJsInterpreterManager.getInstance(this.myProject).setDefault(this.myProjectDefaultInterpreter);
            }
            MultiMap group = MultiMap.create();
            for (int i = 0; i < this.myListModel.size(); ++i) {
                NodeJsInterpreter interpreter = NodeJsInterpreter.tryCast(this.myListModel.elementAt(i));
                if (interpreter == null) continue;
                group.putValue(interpreter.getType(), (Object)interpreter);
            }
            for (Map.Entry entry : group.entrySet()) {
                NodeJsInterpreterType type = (NodeJsInterpreterType)entry.getKey();
                type.setInterpreters(ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
            }
            NodeJsInterpreter interpreter = this.getSelectedInterpreter();
            Pair pair = Pair.create((Object)true, (Object)interpreter);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "showAndGetSelected"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)false, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "showAndGetSelected"));
        }
        return pair;
    }

    private void addIfNeededAndSelect(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog", "addIfNeededAndSelect"));
        }
        int index = this.findInterpreterIndex(interpreter);
        if (index == -1) {
            this.myListModel.addElement(interpreter);
            index = this.myListModel.size() - 1;
        }
        this.myList.setSelectedIndex(index);
    }

    private class SetAsProjectInterpreterAction
    extends DumbAwareAction {
        protected SetAsProjectInterpreterAction() {
            super("Set as Project Interpreter");
        }

        public void update(AnActionEvent e) {
            NodeJsInterpreter interpreter = NodeJsInterpretersDialog.this.getSelectedInterpreter();
            boolean enabled = !NodeJsInterpretersDialog.this.myProjectDefaultField && interpreter instanceof NodeJsLocalInterpreter;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            NodeJsInterpreter interpreter = NodeJsInterpretersDialog.this.getSelectedInterpreter();
            if (!NodeJsInterpretersDialog.this.myProjectDefaultField && interpreter instanceof NodeJsLocalInterpreter) {
                NodeJsInterpretersDialog.this.myProjectDefaultInterpreter = interpreter;
                NodeJsInterpretersDialog.this.myProjectDefaultInterpreterChanged = true;
                NodeJsInterpretersDialog.this.myList.repaint();
            }
        }
    }

    private class EditInterpreterView {
        private final BorderLayout myBorderLayout = new BorderLayout();
        private final JPanel myPanel;
        private NodeJsInterpreter myInterpreter;
        private NodeJsInterpreterEditor myEditor;

        public EditInterpreterView() {
            final Ref emptyTextRef = Ref.create();
            this.myPanel = new JPanel(this.myBorderLayout){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    ((StatusText)emptyTextRef.get()).paint((Component)this, g);
                }
            };
            StatusText emptyText = new StatusText(this.myPanel){

                protected boolean isStatusVisible() {
                    return EditInterpreterView.this.myInterpreter == null;
                }
            };
            emptyText.setText("No interpreter selected");
            emptyTextRef.set((Object)emptyText);
            this.myPanel.setBorder(DialogWrapper.ourDefaultBorder);
        }

        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$EditInterpreterView", "getPanel"));
            }
            return jPanel;
        }

        private void setComponent(@Nullable Component component) {
            Component prevChild = this.myBorderLayout.getLayoutComponent("Center");
            if (prevChild != null) {
                this.myPanel.remove(prevChild);
            }
            if (component != null) {
                this.myPanel.add(component, "Center");
            }
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }

        public void edit(@Nullable NodeJsInterpreter selected) {
            if (this.myInterpreter == selected) {
                return;
            }
            this.apply();
            if (selected == null) {
                this.setComponent(null);
            } else {
                NodeJsInterpreterType<? extends NodeJsInterpreter> oldType = this.myInterpreter != null ? this.myInterpreter.getType() : null;
                NodeJsInterpreterType<? extends NodeJsInterpreter> newType = selected.getType();
                if (newType != oldType) {
                    this.myEditor = newType.getEditor(NodeJsInterpretersDialog.this.myProject);
                    this.setComponent(this.myEditor.getEditorComponent());
                }
                this.myEditor.resetEditor(selected);
            }
            this.myInterpreter = selected;
        }

        private void apply() {
            int ind;
            if (this.myInterpreter != null && (ind = NodeJsInterpretersDialog.this.findInterpreterIndex(this.myInterpreter)) >= 0) {
                Object newInterpreter = this.myEditor.applyEditor();
                NodeJsInterpretersDialog.this.myListModel.set(ind, newInterpreter);
            }
        }
    }

    private static class AddInterpreterAction
    extends DumbAwareAction {
        private final NodeJsInterpreter myInterpreter;
        private final Consumer<NodeJsInterpreter> myCallback;

        public AddInterpreterAction(@NotNull NodeJsInterpreter interpreter, @NotNull Consumer<NodeJsInterpreter> callback) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterAction", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterAction", "<init>"));
            }
            super(interpreter.getPresentableName());
            this.myInterpreter = interpreter;
            this.myCallback = callback;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myCallback.consume((Object)this.myInterpreter);
        }
    }

    private static class AddInterpreterTypeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final NodeJsInterpreterType myType;
        private final Consumer<NodeJsInterpreter> myCallback;

        public AddInterpreterTypeAction(@NotNull Project project, @NotNull NodeJsInterpreterType type, @NotNull Consumer<NodeJsInterpreter> callback) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction", "<init>"));
            }
            super("Add " + StringUtil.capitalize((String)type.getName()) + "...");
            this.myProject = project;
            this.myType = type;
            this.myCallback = callback;
        }

        public void actionPerformed(AnActionEvent e) {
            Object addedInterpreter = this.myType.showAddDialog(this.myProject);
            if (addedInterpreter != null) {
                this.myCallback.consume(addedInterpreter);
            }
        }

        public void update(AnActionEvent e) {
            boolean available = this.myType.isAvailable();
            e.getPresentation().setEnabledAndVisible(available);
        }
    }
}

