/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NodeJsLocalInterpreterEditor
implements NodeJsInterpreterEditor<NodeJsLocalInterpreter> {
    private final Project myProject;
    private final JBTextField myNodeField;
    private final TextFieldWithHistoryWithBrowseButton myNpmPackageField;
    private final JPanel myPanel;
    private String myInterpreterSystemIndependentPath;

    public NodeJsLocalInterpreterEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "<init>"));
        }
        this.myProject = project;
        this.myNodeField = new JBTextField();
        this.myNodeField.setEditable(false);
        this.myNpmPackageField = this.createNpmPackageField(project);
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent("&Node interpreter:", (JComponent)this.myNodeField).addLabeledComponent("Np&m package:", (JComponent)this.myNpmPackageField).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    @NotNull
    public TextFieldWithHistoryWithBrowseButton createNpmPackageField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "createNpmPackageField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select npm Package", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (NotNullProducer)new NotNullProducer<List<String>>(){

            @NotNull
            public List<String> produce() {
                List<String> npmDirs = NodeJsLocalInterpreterEditor.this.detectAllNpmPackageDirs();
                Collections.sort(npmDirs);
                List<String> list = npmDirs;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor$1", "produce"));
                }
                return list;
            }
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "createNpmPackageField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public List<String> detectAllNpmPackageDirs() {
        ArrayList modules = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = new NodeSettings(this.myInterpreterSystemIndependentPath);
        NodeModuleSearchUtil.findModulesWithName(modules, "npm", this.myProject.getBaseDir(), nodeSettings, true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "detectAllNpmPackageDirs"));
        }
        return arrayList;
    }

    @Override
    public void resetEditor(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "resetEditor"));
        }
        this.myInterpreterSystemIndependentPath = interpreter.getInterpreterSystemIndependentPath();
        this.myNodeField.setText(interpreter.getPresentableName());
        this.myNpmPackageField.setText(StringUtil.notNullize((String)interpreter.getNpmPackageDir()));
    }

    @Override
    @NotNull
    public NodeJsLocalInterpreter applyEditor() {
        NodeJsLocalInterpreter nodeJsLocalInterpreter = new NodeJsLocalInterpreter(this.myInterpreterSystemIndependentPath, this.myNpmPackageField.getText());
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "applyEditor"));
        }
        return nodeJsLocalInterpreter;
    }

    @Override
    @NotNull
    public Component getEditorComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "getEditorComponent"));
        }
        return jPanel;
    }
}

