/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreLibraryManager {
    public static final String LIBRARY_NAME = "Node.js Core";
    private final Project myProject;
    private JSLibraryMappings myMappings;
    @Nullable
    private volatile LibraryWrapper myWrapper;

    public NodeJsCoreLibraryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "<init>"));
        }
        this.myMappings = null;
        this.myWrapper = null;
        this.myProject = project;
    }

    @NotNull
    public static NodeJsCoreLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "getInstance"));
        }
        NodeJsCoreLibraryManager nodeJsCoreLibraryManager = (NodeJsCoreLibraryManager)ServiceManager.getService((Project)project, NodeJsCoreLibraryManager.class);
        if (nodeJsCoreLibraryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "getInstance"));
        }
        return nodeJsCoreLibraryManager;
    }

    public void setScriptingLibraryModel(@Nullable ScriptingLibraryModel libraryModel) {
        this.myWrapper = libraryModel == null ? null : new LibraryWrapper(libraryModel);
    }

    public static boolean isCoreModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isCoreModuleName"));
        }
        return NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName);
    }

    public boolean isCoreLibraryConfigured() {
        LibraryWrapper wrapper = this.myWrapper;
        return wrapper != null;
    }

    public boolean isCoreModuleLibraryFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isCoreModuleLibraryFile"));
        }
        LibraryWrapper wrapper = this.myWrapper;
        return wrapper != null && wrapper.containsFile(virtualFile);
    }

    @NotNull
    public Collection<String> listCoreModuleNames() {
        LibraryWrapper wrapper = this.myWrapper;
        if (wrapper == null) {
            ImmutableList<String> immutableList = NodeJsCoreModulesCatalog.INSTANCE.getPublicCoreModules();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "listCoreModuleNames"));
            }
            return immutableList;
        }
        ImmutableList<String> immutableList = wrapper.getPublicCoreModuleNames();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "listCoreModuleNames"));
        }
        return immutableList;
    }

    @Nullable
    public VirtualFile findCoreModuleFileByName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "findCoreModuleFileByName"));
        }
        LibraryWrapper wrapper = this.myWrapper;
        if (wrapper == null) {
            return null;
        }
        return wrapper.getFileByModuleName(moduleName);
    }

    @NotNull
    public Set<VirtualFile> getCoreModules() {
        LibraryWrapper wrapper = this.myWrapper;
        if (wrapper == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "getCoreModules"));
            }
            return set;
        }
        ImmutableSet<VirtualFile> immutableSet = wrapper.getPublicCoreModuleFiles();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "getCoreModules"));
        }
        return immutableSet;
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isAssociatedWithNodeCoreLibrary"));
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(psiFile.getProject(), virtualFile);
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isAssociatedWithNodeCoreLibrary"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isAssociatedWithNodeCoreLibrary"));
        }
        NodeJsCoreLibraryManager manager = NodeJsCoreLibraryManager.getInstance(project);
        return manager.isAssociatedWithNodeCoreLibrary(file);
    }

    public boolean isAssociatedWithNodeCoreLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager", "isAssociatedWithNodeCoreLibrary"));
        }
        JSLibraryMappings mappings = this.myMappings;
        if (mappings == null) {
            this.myMappings = mappings = JSLibraryMappings.getInstance(this.myProject);
        }
        return mappings.isLibraryInScopeFor(file, LIBRARY_NAME);
    }

    private static class LibraryWrapper {
        private final ImmutableMap<String, VirtualFile> myPublicCoreModuleFileByNameMap;
        private final ImmutableList<String> myPublicCoreModuleNames;
        private final ImmutableSet<VirtualFile> myPublicCoreModuleFiles;

        private LibraryWrapper(@NotNull ScriptingLibraryModel libraryModel) {
            if (libraryModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper", "<init>"));
            }
            Set allFiles = ContainerUtil.union((Set)libraryModel.getSourceFiles(), (Set)libraryModel.getCompactFiles());
            Map publicCoreModuleFileByNameMap = ContainerUtilRt.newHashMap((int)allFiles.size());
            for (VirtualFile file : allFiles) {
                String moduleName = file.getNameWithoutExtension();
                if (!NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName)) continue;
                publicCoreModuleFileByNameMap.put(moduleName, file);
            }
            this.myPublicCoreModuleFileByNameMap = ImmutableMap.copyOf((Map)publicCoreModuleFileByNameMap);
            this.myPublicCoreModuleNames = ImmutableList.copyOf(publicCoreModuleFileByNameMap.keySet());
            this.myPublicCoreModuleFiles = ImmutableSet.copyOf(publicCoreModuleFileByNameMap.values());
        }

        @Nullable
        public VirtualFile getFileByModuleName(@NotNull String moduleName) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper", "getFileByModuleName"));
            }
            return (VirtualFile)this.myPublicCoreModuleFileByNameMap.get((Object)moduleName);
        }

        public boolean containsFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper", "containsFile"));
            }
            return this.myPublicCoreModuleFiles.contains((Object)file);
        }

        @NotNull
        public ImmutableList<String> getPublicCoreModuleNames() {
            ImmutableList<String> immutableList = this.myPublicCoreModuleNames;
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper", "getPublicCoreModuleNames"));
            }
            return immutableList;
        }

        public ImmutableSet<VirtualFile> getPublicCoreModuleFiles() {
            return this.myPublicCoreModuleFiles;
        }
    }
}

