/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ES6ImportSpecifierCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof ES6ImportSpecifier);
        result.addAllElements(ES6ImportSpecifierCompletionProvider.getVariants((ES6ImportSpecifier)parent));
    }

    public static Iterable<LookupElement> getVariants(@NotNull ES6ImportSpecifier importSpecifier) {
        if (importSpecifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSpecifier", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "getVariants"));
        }
        SinkResolveProcessor<CompletionResultSink> processor = ES6ImportSpecifierCompletionProvider.createCompletionProcessor((PsiElement)importSpecifier);
        ES6PsiUtil.processSpecifier((ES6ImportExportSpecifier)importSpecifier, processor, null);
        List<PsiElement> elements = processor.getResults();
        if (ContainerUtil.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return ES6ImportSpecifierCompletionProvider.buildResult(elements);
    }

    @NotNull
    public static List<LookupElement> buildResult(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "buildResult"));
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>(elements.size());
        for (PsiElement element : elements) {
            PsiElement resolve;
            if (element instanceof ES6ImportExportSpecifier && (resolve = ((ES6ImportExportSpecifier)element).resolve()) != null) {
                element = resolve;
            }
            if (!(element instanceof PsiNamedElement)) continue;
            Couple<String> typeAndTail = JSLookupUtilImpl.getTypeAndTailTexts(element, null);
            LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)element)).withIcon(JSLookupUtilImpl.getIcon(element, false)).withTypeText((String)typeAndTail.first).withStrikeoutness(JSDocumentationUtils.isDeprecated(element)).withBoldness(true).withTailText((String)typeAndTail.second, false);
            result.add((LookupElement)builder);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "buildResult"));
        }
        return arrayList;
    }

    @NotNull
    public static SinkResolveProcessor<CompletionResultSink> createCompletionProcessor(PsiElement importSpecifier) {
        SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink(importSpecifier));
        processor.setTypeContext(true);
        processor.getAccessibilityProcessingHandler().setAcceptOnlyExportedSymbols();
        processor.setSkipImplicitDeclarations(true);
        SinkResolveProcessor<CompletionResultSink> sinkResolveProcessor = processor;
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportSpecifierCompletionProvider", "createCompletionProcessor"));
        }
        return sinkResolveProcessor;
    }
}

