/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportedBindingStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportedBindingImpl
extends JSStubElementImpl<ES6ImportedBindingStub>
implements ES6ImportedBinding,
StubBasedPsiElement<ES6ImportedBindingStub> {
    public ES6ImportedBindingImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportedBindingImpl(ES6ImportedBindingStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.IMPORTED_BINDING);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ImportedBinding((ES6ImportedBinding)this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        ASTNode lastChild;
        for (lastChild = this.getNode().getLastChildNode(); lastChild != null && !JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET.contains(lastChild.getElementType()); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    public String getName() {
        ES6ImportedBindingStub stub = (ES6ImportedBindingStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createNameIdentifier(this.getProject(), name));
        }
        return this;
    }

    @NotNull
    public Collection<PsiElement> findReferencedElements() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof ES6ImportDeclaration)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        ES6FromClause fromClause = ((ES6ImportDeclaration)parent).getFromClause();
        if (fromClause != null) {
            Collection elements = fromClause.resolveReferencedElements();
            if (this.isNamespaceImport()) {
                Collection<PsiElement> collection = ES6PsiUtil.getBindingAllPossibleExports(elements);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
                }
                return collection;
            }
            SmartList result = new SmartList();
            for (PsiElement element : elements) {
                if (element instanceof JSElement) {
                    TypeScriptExportAssignment assignment;
                    JSElement export = ES6PsiUtil.findDefaultExport((JSElement)element);
                    if (export != null) {
                        result.add((Object)export);
                    } else if (!DialectDetector.isTypeScript((PsiElement)this) && (assignment = TypeScriptPsiUtil.findExportAssignment(element)) != null) {
                        result.add((Object)assignment);
                    }
                }
                if (!(element instanceof JSFile) || !((JSFile)element).isCommonJSModule() || ((JSFile)element).hasES6Syntax() || DialectDetector.isTypeScript((PsiElement)this)) continue;
                result.add((Object)element);
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
            }
            return smartList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedBindingImpl", "findReferencedElements"));
        }
        return list;
    }

    public boolean isNamespaceImport() {
        ES6ImportedBindingStub stub = (ES6ImportedBindingStub)this.getStub();
        if (stub != null) {
            return stub.isNamespaceImport();
        }
        return this.getNode().findChildByType(JSTokenTypes.MULT) != null;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            return identifier.getTextOffset();
        }
        return super.getTextOffset();
    }
}

