/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSModuleReference;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptPathMappingReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.psi.impl.TypeScriptExternalModuleReferenceImpl;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_KEY = Key.create((String)"TypeScript.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<Collection<PsiElement>> compute(PsiElement param) {
            String text = ES6PsiUtil.getReferenceModuleText(param);
            if (StringUtil.isEmpty((String)text)) {
                return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            PsiReference[] references = ES6PsiUtil.createImportExportFromClauseReferences(param, 0, text, null);
            Collection elements = ES6PsiUtil.findReferencedModules(param, references);
            return CachedValueProvider.Result.create((Object)elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };

    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "resolveModuleReferences"));
        }
        return (Collection)CachedValuesManager.getManager((Project)moduleReference.getProject()).getParameterizedCachedValue((UserDataHolder)moduleReference, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)moduleReference);
    }

    @Nullable
    private static String getReferenceModuleText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getReferenceModuleText"));
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getName();
        }
        return null;
    }

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
            }
            return arrayList;
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull JSElement scopeElement) {
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findDefaultExport"));
        }
        Collection exportDefaultAssignments = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        if (!exportDefaultAssignments.isEmpty()) {
            return (JSElement)exportDefaultAssignments.iterator().next();
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(new ResolveResultSink((PsiElement)scopeElement, "default"));
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.getAccessibilityProcessingHandler().setAcceptOnlyExportedSymbols();
        JSResolveUtil.processDeclarationsInScope(scopeElement, processor, ResolveState.initial(), (PsiElement)scopeElement, (PsiElement)scopeElement);
        PsiElement result = processor.getResult();
        return result instanceof JSElement ? (JSElement)result : null;
    }

    public static boolean isAsyncContext(@Nullable JSFunction parent) {
        JSAttributeList attributeList;
        return parent != null && (attributeList = parent.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, final boolean includeExportSpecifiers) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                }
                if (!includeExportSpecifiers && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                return processor.execute(element, state);
            }
        };
        if (!JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor, state, lastParent, place)) {
            return false;
        }
        return ES6PsiUtil.processExportAllDeclarations(scope, place, processor, null);
    }

    private static boolean processExportAllDeclarations(@NotNull JSElement owner, PsiElement place, @NotNull PsiScopeProcessor processor, Collection<PsiElement> visited) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (visited != null && !visited.add((PsiElement)owner)) {
            return false;
        }
        PsiElement[] children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS);
        if (children == null) {
            return true;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, ResolveState.initial(), (PsiElement)element.getContainingFile(), place, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getFromClauseResolvedReferences"));
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            for (PsiElement psiElement : typeResolveResult.getElements()) {
                result.add(psiElement);
            }
        }
        return result;
    }

    public static void processSpecifier(@NotNull ES6ImportExportSpecifier specifier, final @NotNull PsiScopeProcessor processor, @Nullable PsiElement defaultScope) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (declaration == null) {
            return;
        }
        ES6FromClause clause = declaration.getFromClause();
        List scopes = null;
        if (clause != null) {
            scopes = ES6PsiUtil.getFromClauseResolvedReferences(clause);
        } else if (defaultScope != null && defaultScope instanceof JSElement) {
            scopes = ContainerUtil.createMaybeSingletonList((Object)defaultScope);
        }
        if (scopes == null) {
            return;
        }
        for (PsiElement scope : scopes) {
            if (!(scope instanceof JSElement)) continue;
            if (processor instanceof JSTypeProcessor && scope instanceof JSVariable) {
                JSType possibleType = ((JSVariable)scope).getType();
                if (possibleType == null) continue;
                ((JSTypeProcessor)processor).process(possibleType, new JSEvaluateContext(scope.getContainingFile()), scope);
                continue;
            }
            if (scope == defaultScope) {
                JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor instanceof JSResolveProcessorBase ? ((JSResolveProcessorBase)processor).getName() : null){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$3", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$3", "execute"));
                        }
                        if (element instanceof ES6ExportSpecifier) {
                            return true;
                        }
                        return processor.execute(element, state);
                    }
                };
                JSResolveUtil.processDeclarationsInScope((JSElement)scope, delegatingProcessor, ResolveState.initial(), (PsiElement)scope.getContainingFile(), (PsiElement)specifier);
                continue;
            }
            ES6PsiUtil.processExportDeclarationInScope((JSElement)scope, processor, ResolveState.initial(), null, (PsiElement)specifier);
        }
    }

    public static SinkResolveProcessor<? extends ResultSink> createSpecifierResolveProcessor(@NotNull ES6ImportExportSpecifierBase specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        String name = specifier.getReferenceName();
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)specifier).createCompletionItemProcessor(new ResolveResultSink((PsiElement)specifier, name, true), specifier.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getExportScope"));
        }
        return element instanceof PsiFile ? null : (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "calcImportExportFromClauseReferences"));
        }
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText(element);
        if (pair == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return ES6PsiUtil.createImportExportFromClauseReferences(element, ((PsiElement)pair.second).getStartOffsetInParent() + 1, (String)pair.first, provider);
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        String unquoted = StringUtil.unquoteString((String)text);
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(host)) continue;
            Object[] references = contributor.getAllReferences(unquoted, host, offset, provider);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references);
        }
        PsiReference[] tsModuleReferences = DialectDetector.isTypeScript(host) ? TypeScriptExternalModuleReferenceImpl.getExternalModuleReferences(host, text, offset) : TypeScriptExternalModuleReferenceImpl.getSimpleExternalModuleReferences(host, text, offset);
        result = ES6PsiUtil.addReferences((PsiReference[])result, tsModuleReferences);
        return result;
    }

    private static PsiReference[] addReferences(@NotNull PsiReference[] current, @NotNull PsiReference[] toAdd) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addReferences"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addReferences"));
        }
        if (toAdd != PsiReference.EMPTY_ARRAY) {
            current = (PsiReference[])ArrayUtil.mergeArrays((Object[])current, (Object[])toAdd);
        }
        return current;
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope, processor, state, lastParent, place, null);
    }

    private static boolean processExportDeclarationInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @Nullable Collection<PsiElement> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        boolean hasIncompleteMatch = false;
        if (scope instanceof JSFile && !DialectDetector.isTypeScript((PsiElement)scope)) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)((JSFile)scope));
            Processor<JSPsiElementBase> namespaceMembersProcessor = new Processor<JSPsiElementBase>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(JSPsiElementBase element) {
                    boolean processingFromIndices = false;
                    try {
                        if (processor instanceof ResolveProcessor) {
                            if (((ResolveProcessor)processor).getName() == null && (element.getAccessType() == JSAttributeList.AccessType.PRIVATE || JSVisibilityUtil.seemsToBePrivateSymbol(element.getName()))) {
                                boolean bl = true;
                                return bl;
                            }
                            processingFromIndices = ((ResolveProcessor)processor).isProcessingFromIndices();
                            ((ResolveProcessor)processor).setSkipImplicitDeclarations(true);
                        }
                        boolean bl = processor.execute((PsiElement)element, ResolveState.initial());
                        return bl;
                    }
                    finally {
                        if (processor instanceof ResolveProcessor) {
                            ((ResolveProcessor)processor).setSkipImplicitDeclarations(processingFromIndices);
                        }
                    }
                }
            };
            JSClassResolver.getInstance().processNamespaceMembers("exports", fileScope, namespaceMembersProcessor);
            JSClassResolver.getInstance().processNamespaceMembers("module.exports", fileScope, namespaceMembersProcessor);
            hasIncompleteMatch = ((JSFile)scope).getExportsInnerAlias() != null || !((JSFile)scope).hasES6Syntax();
        }
        JSExportedElementsProcessor exportedElementsProcessor = processor instanceof JSExportedElementsProcessor ? (JSExportedElementsProcessor)processor : new JSExportedElementsProcessor(processor);
        boolean result = true;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)scope);
        if (isTypeScript || scope instanceof JSFile && ((JSFile)scope).hasES6Syntax()) {
            boolean bl = result = isTypeScript ? JSResolveUtil.processDeclarationsInScope(scope, exportedElementsProcessor, state, lastParent, place) : JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, exportedElementsProcessor, false);
            if (result) {
                ES6PsiUtil.processExportAllDeclarations(scope, place, exportedElementsProcessor, visited);
            }
            if (result && DialectDetector.isTypeScript((PsiElement)scope) && exportedElementsProcessor.getName() != null && processor instanceof JSResolveProcessorBase) {
                TypeScriptResolveHelper.processGlobalThings((JSResolveProcessorBase)processor, ResolveState.initial(), (PsiElement)scope);
            }
        }
        return hasIncompleteMatch || result;
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportSpecifierAlias || item instanceof TypeScriptImportStatement;
    }

    private static Collection<PsiElement> findReferencedModules(PsiElement context, PsiReference[] references) {
        Object modules;
        THashSet results = new THashSet();
        for (PsiReference reference : references) {
            if (reference == null || reference instanceof FileReference && !((FileReference)reference).isLast() || reference instanceof TypeScriptPathMappingReference) continue;
            Collection<PsiElement> currentResults = JSResolveUtil.getResolvedElements(reference);
            String[] extensions = DialectDetector.isTypeScript(context) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : JSModuleReference.IMPLICIT_EXTENSIONS;
            block1: for (PsiElement result : currentResults) {
                if (result instanceof PsiDirectory) {
                    for (String ext : extensions) {
                        PsiFile file = ((PsiDirectory)result).findFile("index" + ext);
                        if (file == null) continue;
                        results.add(file);
                        continue block1;
                    }
                    continue;
                }
                results.add(result);
            }
        }
        List typeScriptModules = ContainerUtil.filter((Collection)results, TypeScriptPsiUtil.IS_TS_MODULE);
        Object object = modules = typeScriptModules.isEmpty() ? results : typeScriptModules;
        if (context instanceof TypeScriptModule && TypeScriptAugmentationUtil.isExternalModuleAugmentation((TypeScriptModule)context)) {
            return modules;
        }
        return ES6PsiUtil.mergeWithAugmentations(context, (Collection<PsiElement>)modules);
    }

    @NotNull
    private static Collection<PsiElement> mergeWithAugmentations(PsiElement context, Collection<PsiElement> modules) {
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(context, modules);
        if (augmentations.isEmpty()) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "mergeWithAugmentations"));
            }
            return collection;
        }
        ArrayList result = ContainerUtil.newArrayList(modules);
        result.addAll(augmentations);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "mergeWithAugmentations"));
        }
        return arrayList;
    }

    private static class JSExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public JSExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateProcessor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "<init>"));
            }
            super(delegateProcessor instanceof JSResolveProcessorBase ? ((JSResolveProcessorBase)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "execute"));
            }
            if (element instanceof ES6ExportSpecifier) {
                ResolveResult[] results;
                ES6ImportExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                for (ResolveResult result : results = ((ES6ExportSpecifier)element).multiResolve(false)) {
                    PsiElement resultElement;
                    if (!result.isValidResult() || (resultElement = result.getElement()) == null || this.myDelegate.execute(resultElement, state)) continue;
                    return false;
                }
            } else {
                if (ES6ImportHandler.isExported(element)) {
                    return this.myDelegate.execute(element, state);
                }
                if (this.myDelegate instanceof SinkResolveProcessor) {
                    ((SinkResolveProcessor)this.myDelegate).addPossibleCandidateResult(element, "javascript.element.need.to.be.exported");
                }
            }
            return true;
        }
    }
}

