/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript._JavaScriptLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class JSFlexAdapter
extends MergingLexerAdapterBase {
    private static final int NESTED_BLOCKS_COUNT_SHIFT = 5;
    private static final int BASE_STATE_MASK = 31;
    public static final MyMergeFunction MERGE_FUNCTION = new MyMergeFunction();

    public JSFlexAdapter(@NotNull DialectOptionHolder optionHolder) {
        if (optionHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionHolder", "com/intellij/lang/javascript/JSFlexAdapter", "<init>"));
        }
        this(new _JavaScriptLexer(false, optionHolder));
    }

    public JSFlexAdapter(FlexLexer lexer) {
        super((Lexer)new FlexAdapter(lexer));
        assert (lexer instanceof _JavaScriptLexer);
    }

    private _JavaScriptLexer getFlex() {
        return (_JavaScriptLexer)((FlexAdapter)this.getOriginal()).getFlex();
    }

    public MergeFunction getMergeFunction() {
        return MERGE_FUNCTION;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lang/javascript/JSFlexAdapter", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState & 0x1F);
        this.getFlex().clearState(initialState >> 5);
    }

    public int getState() {
        return super.getState() + (this.getFlex().getNestedBlocksCount() << 5);
    }

    private static class MyMergeFunction
    implements MergeFunction {
        private MyMergeFunction() {
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (type != JSTokenTypes.XML_JS_SCRIPT) {
                if (type == JSTokenTypes.STRING_LITERAL_PART) {
                    if (originalLexer.getTokenType() == type) {
                        originalLexer.advance();
                    }
                    return JSTokenTypes.STRING_LITERAL;
                }
                if (type == JSTokenTypes.HEREDOC_BODY || type == JSTokenTypes.XML_TAG_CONTENT || type == JSTokenTypes.STRING_TEMPLATE_PART) {
                    while (originalLexer.getTokenType() == type) {
                        originalLexer.advance();
                    }
                }
                return type;
            }
            int braceBalance = 1;
            do {
                IElementType tokenType = originalLexer.getTokenType();
                String text = originalLexer.getTokenText();
                if (tokenType != JSTokenTypes.XML_JS_SCRIPT) break;
                originalLexer.advance();
                if ("{".equals(text)) {
                    ++braceBalance;
                }
                if (!"}".equals(text)) continue;
                --braceBalance;
            } while (braceBalance != 0);
            return type;
        }
    }
}

