/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.tree.IElementType;

public abstract class JSNodeVisitor {
    public final void visit(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof JSFileElementType) {
            this.visitFile(node);
        } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type)) {
            this.visitFunctionDeclaration(node);
        } else if (type == JSStubElementTypes.PARAMETER_LIST) {
            this.visitParameterList(node);
        } else if (type == JSElementTypes.LOCAL_VARIABLE) {
            this.visitLocalVariable(node);
        } else if (JSElementTypes.BODY_VARIABLES.contains(type)) {
            this.visitVariable(node);
        } else if (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(type)) {
            this.visitParameter(node);
        } else if (type == JSElementTypes.ARGUMENT_LIST || type == NashornJSElementTypes.ARGUMENT_LIST) {
            this.visitArgumentList(node);
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type)) {
            this.visitBlock(node);
        } else if (type == JSElementTypes.LABELED_STATEMENT) {
            this.visitLabeledStatement(node);
        } else if (type == JSElementTypes.EXPRESSION_STATEMENT) {
            this.visitExpressionStatement(node);
        } else if (type == JSStubElementTypes.VAR_STATEMENT) {
            this.visitVarStatement(node);
        } else if (type == JSElementTypes.EMPTY_STATEMENT) {
            this.visitEmptyStatement(node);
        } else if (type == JSElementTypes.IF_STATEMENT) {
            this.visitIfStatement(node);
        } else if (type == JSElementTypes.CONTINUE_STATEMENT) {
            this.visitContinueStatement(node);
        } else if (type == JSElementTypes.BREAK_STATEMENT) {
            this.visitBreakStatement(node);
        } else if (type == JSElementTypes.WITH_STATEMENT) {
            this.visitWithStatement(node);
        } else if (type == JSStubElementTypes.RETURN_STATEMENT) {
            this.visitReturnStatement(node);
        } else if (type == JSElementTypes.YIELD_EXPRESSION) {
            this.visitYieldExpression(node);
        } else if (type == JSElementTypes.THROW_STATEMENT) {
            this.visitThrowStatement(node);
        } else if (type == JSElementTypes.TRY_STATEMENT) {
            this.visitTryStatement(node);
        } else if (type == JSElementTypes.CATCH_BLOCK) {
            this.visitCatchBlock(node);
        } else if (type == JSElementTypes.SWITCH_STATEMENT) {
            this.visitSwitchStatement(node);
        } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(type)) {
            this.visitCaseClause(node);
        } else if (type == JSElementTypes.WHILE_STATEMENT) {
            this.visitWhileStatement(node);
        } else if (type == JSElementTypes.DOWHILE_STATEMENT) {
            this.visitDoWhileStatement(node);
        } else if (type == JSElementTypes.FOR_STATEMENT) {
            this.visitForStatement(node);
        } else if (type == JSElementTypes.FOR_IN_STATEMENT) {
            this.visitForInStatement(node);
        } else if (type == JSElementTypes.THIS_EXPRESSION) {
            this.visitThisExpression(node);
        } else if (type == JSStubElementTypes.LITERAL_EXPRESSION) {
            this.visitLiteralExpression(node);
        } else if (type == JSElementTypes.REFERENCE_EXPRESSION) {
            this.visitReferenceExpression(node);
        } else if (type == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            this.visitParenthesizedExpression(node);
        } else if (type == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            this.visitArrayLiteralExpression(node);
        } else if (type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            this.visitObjectLiteralExpression(node);
        } else if (type instanceof JSPropertyElementType) {
            this.visitProperty(node);
        } else if (type == JSElementTypes.BINARY_EXPRESSION) {
            this.visitBinaryExpression(node);
        } else if (type == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            this.visitAssignmentExpression(node);
        } else if (type == JSElementTypes.COMMA_EXPRESSION) {
            this.visitCommaExpression(node);
        } else if (type == JSElementTypes.CONDITIONAL_EXPRESSION) {
            this.visitConditionalExpression(node);
        } else if (type == JSElementTypes.ARRAY_COMPREHENSION) {
            this.visitArrayComprehension(node);
        } else if (type == JSElementTypes.POSTFIX_EXPRESSION) {
            this.visitPostfixExpression(node);
        } else if (type == JSElementTypes.PREFIX_EXPRESSION) {
            this.visitPrefixExpression(node);
        } else if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) {
            this.visitFunctionExpression(node);
        } else if (JSElementTypes.FUNCTION_PROPERTIES.contains(type)) {
            this.visitFunctionProperty(node);
        } else if (JSElementTypes.NEW_EXPRESSIONS.contains(type)) {
            this.visitNewExpression(node);
        } else if (type == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION) {
            this.visitIndexedPropertyAccessExpression(node);
        } else if (type == JSStubElementTypes.ATTRIBUTE_LIST) {
            this.visitAttributeList(node);
        } else if (type == JSStubElementTypes.CALL_EXPRESSION) {
            this.visitCallExpression(node);
        } else if (type == JSTokenTypes.C_STYLE_COMMENT) {
            this.visitComment(node);
        } else if (type == JSTokenTypes.DOC_COMMENT) {
            this.visitDocComment(node);
        } else if (type == JSElementTypes.EMBEDDED_CONTENT) {
            this.visitEmbeddedContent(node);
        } else if (type == JSStubElementTypes.PACKAGE_STATEMENT) {
            this.visitPackageStatement(node);
        } else if (type instanceof JSClassElementTypeBase) {
            this.visitClass(node);
        } else if (type == JSElementTypes.XML_LITERAL_EXPRESSION) {
            this.visitXmlLiteralExpression(node);
        } else if (type == JSStubElementTypes.IMPORT_STATEMENT) {
            this.visitImportStatement(node);
        } else if (type == JSStubElementTypes.TYPESCRIPT_MODULE) {
            this.visitTypeScriptModule(node);
        } else if (type == JSStubElementTypes.TYPESCRIPT_CLASS || type == JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION) {
            this.visitClass(node);
        } else if (type == JSStubElementTypes.TYPESCRIPT_INTERFACE) {
            this.visitTypeScriptInterface(node);
        } else if (type == ES6ElementTypes.IMPORT_DECLARATION) {
            this.visitES6ImportDeclaration(node);
        } else if (type == JSStubElementTypes.DESTRUCTURING_OBJECT) {
            this.visitDestructuringObject(node);
        } else if (type == ES6ElementTypes.EXPORT_DECLARATION) {
            this.visitES6ExportDeclaration(node);
        } else if (type == TypeScriptElementTypes.OBJECT_TYPE) {
            this.visitObjectType(node);
        } else if (TypeScriptElementTypes.TYPE_MEMBERS.contains(type)) {
            this.visitTypeMember(node);
        } else {
            this.visitElement(node);
        }
    }

    protected void visitYieldExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitXmlLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitImportStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAttributeList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitPackageStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitClass(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFile(ASTNode node) {
        this.visitElement(node);
    }

    public void visitCallExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitNewExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitFunctionExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitFunctionProperty(ASTNode node) {
        this.visitProperty(node);
    }

    public void visitPrefixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitPostfixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitConditionalExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitArrayComprehension(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitCommaExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitTypeMember(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAssignmentExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitBinaryExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitProperty(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitArrayLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitParenthesizedExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitReferenceExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitThisExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitForInStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitForStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDoWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCaseClause(ASTNode node) {
        this.visitElement(node);
    }

    public void visitSwitchStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCatchBlock(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTryStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitThrowStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitReturnStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWithStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBreakStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitContinueStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitIfStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDestructuringObject(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitEmptyStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitVarStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ImportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ExportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitExpressionStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitLabeledStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBlock(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitArgumentList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitParameter(ASTNode node) {
        this.visitVariable(node);
    }

    public void visitVariable(ASTNode node) {
        this.visitElement(node);
    }

    public void visitLocalVariable(ASTNode node) {
        this.visitVariable(node);
    }

    public void visitParameterList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitEmbeddedContent(ASTNode node) {
        this.visitElement(node);
    }

    public void visitElement(ASTNode node) {
    }

    public void visitSourceElement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFunctionDeclaration(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitStatement(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitExpression(ASTNode node) {
        this.visitElement(node);
    }

    public void visitDocComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptModule(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptInterface(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectType(ASTNode node) {
        this.visitElement(node);
    }
}

