/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        JSLanguageDialect dialect = virtualFile != null && project != null ? DialectDetector.getLanguageDialect(virtualFile, project) : null;
        DialectOptionHolder optionHolder = dialect != null ? dialect.getOptionHolder() : JavascriptLanguage.DIALECT_OPTION_HOLDER;
        JSHighlighter jSHighlighter = new JSHighlighter(optionHolder);
        if (jSHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return jSHighlighter;
    }
}

