/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.javascript.BaseJSTokenTypes;
import com.intellij.lang.javascript.JSCompositeElementType;
import com.intellij.lang.javascript.JSDocLexer;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JSEqualElementType;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSDocParsing;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NonNls;

public interface JSTokenTypes {
    public static final IElementType IDENTIFIER = new JSElementType("IDENTIFIER");
    public static final IElementType ANY_IDENTIFIER = new JSElementType("ANY_IDENTIFIER");
    public static final IElementType WHITE_SPACE = BaseJSTokenTypes.WHITE_SPACE;
    public static final TokenSet PARSER_WHITE_SPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{WHITE_SPACE});
    public static final IElementType BAD_CHARACTER = TokenType.BAD_CHARACTER;
    public static final IElementType END_OF_LINE_COMMENT = new JSElementType("END_OF_LINE_COMMENT");
    public static final IElementType C_STYLE_COMMENT = new JSElementType("C_STYLE_COMMENT");
    public static final IElementType XML_STYLE_COMMENT = new JSElementType("XML_STYLE_COMMENT");
    public static final IElementType XML_STYLE_COMMENT_START = new JSElementType("XML_STYLE_COMMENT_START");
    public static final IElementType XML_JS_TEXT = new JSElementType("XML_JS_TEXT");
    public static final TokenSet XML_JS_TEXT_SET = TokenSet.create((IElementType[])new IElementType[]{XML_JS_TEXT});
    public static final IElementType DOC_COMMENT = JSStubElementTypes.DOC_COMMENT;
    public static final IElementType DOC_COMMENT_TOKEN = new CustomParsingType("JSDOC_COMMENT_TOKEN", (Language)JavascriptLanguage.INSTANCE){

        public ASTNode parse(CharSequence text, CharTable table) {
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
            PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)new JSDocLexer(false), text);
            JSDocParsing.parseJSDoc(builder);
            return builder.getTreeBuilt();
        }
    };
    public static final IElementType BREAK_KEYWORD = new JSElementType("BREAK_KEYWORD");
    public static final IElementType CASE_KEYWORD = new JSElementType("CASE_KEYWORD");
    public static final IElementType CATCH_KEYWORD = new JSElementType("CATCH_KEYWORD");
    public static final IElementType CONST_KEYWORD = new JSElementType("CONST_KEYWORD");
    public static final IElementType CONTINUE_KEYWORD = new JSElementType("CONTINUE_KEYWORD");
    public static final IElementType DEBUGGER_KEYWORD = new JSElementType("DEBUGGER_KEYWORD");
    public static final IElementType DELETE_KEYWORD = new JSElementType("DELETE_KEYWORD");
    public static final IElementType DEFAULT_KEYWORD = new JSElementType("DEFAULT_KEYWORD");
    public static final IElementType DO_KEYWORD = new JSElementType("DO_KEYWORD");
    public static final IElementType ELSE_KEYWORD = new JSElementType("ELSE_KEYWORD");
    public static final IElementType FINALLY_KEYWORD = new JSElementType("FINALLY_KEYWORD");
    public static final IElementType FOR_KEYWORD = new JSElementType("FOR_KEYWORD");
    public static final IElementType FUNCTION_KEYWORD = new JSElementType("FUNCTION_KEYWORD");
    public static final IElementType IF_KEYWORD = new JSElementType("IF_KEYWORD");
    public static final IElementType IN_KEYWORD = new JSElementType("IN_KEYWORD");
    public static final IElementType INSTANCEOF_KEYWORD = new JSElementType("INSTANCEOF_KEYWORD");
    public static final IElementType OF_KEYWORD = new JSElementType("OF_KEYWORD");
    public static final IElementType NEW_KEYWORD = new JSElementType("NEW_KEYWORD");
    public static final IElementType RETURN_KEYWORD = new JSElementType("RETURN_KEYWORD");
    public static final IElementType SWITCH_KEYWORD = new JSElementType("SWITCH_KEYWORD");
    public static final IElementType THIS_KEYWORD = new JSElementType("THIS_KEYWORD");
    public static final IElementType THROW_KEYWORD = new JSElementType("THROW_KEYWORD");
    public static final IElementType TRY_KEYWORD = new JSElementType("TRY_KEYWORD");
    public static final IElementType TYPEOF_KEYWORD = new JSElementType("TYPEOF_KEYWORD");
    public static final IElementType VAR_KEYWORD = new JSElementType("VAR_KEYWORD");
    public static final IElementType VOID_KEYWORD = new JSElementType("VOID_KEYWORD");
    public static final IElementType WHILE_KEYWORD = new JSElementType("WHILE_KEYWORD");
    public static final IElementType WITH_KEYWORD = new JSElementType("WITH_KEYWORD");
    public static final IElementType PACKAGE_KEYWORD = new JSElementType("PACKAGE_KEYWORD");
    public static final IElementType IMPORT_KEYWORD = new JSElementType("IMPORT_KEYWORD");
    public static final IElementType CLASS_KEYWORD = new JSElementType("CLASS_KEYWORD");
    public static final IElementType INTERFACE_KEYWORD = new JSElementType("INTERFACE_KEYWORD");
    public static final IElementType PUBLIC_KEYWORD = new JSElementType("PUBLIC_KEYWORD");
    public static final IElementType STATIC_KEYWORD = new JSElementType("STATIC_KEYWORD");
    public static final IElementType INTERNAL_KEYWORD = new JSElementType("INTERNAL_KEYWORD");
    public static final IElementType FINAL_KEYWORD = new JSElementType("FINAL_KEYWORD");
    public static final IElementType DYNAMIC_KEYWORD = new JSElementType("DYNAMIC_KEYWORD");
    public static final IElementType NATIVE_KEYWORD = new JSElementType("NATIVE_KEYWORD");
    public static final IElementType VIRTUAL_KEYWORD = new JSElementType("VIRTUAL_KEYWORD");
    public static final IElementType REQUIRES_KEYWORD = new JSElementType("REQUIRES_KEYWORD");
    public static final IElementType MIXIN_KEYWORD = new JSElementType("MIXIN_KEYWORD");
    public static final IElementType AWAIT_KEYWORD = new JSElementType("AWAIT_KEYWORD");
    public static final IElementType ENUM_KEYWORD = new JSElementType("ENUM_KEYWORD");
    public static final IElementType TYPE_KEYWORD = new JSElementType("TYPE_KEYWORD");
    public static final IElementType EXPORT_KEYWORD = new JSElementType("EXPORT_KEYWORD");
    public static final IElementType MODULE_KEYWORD = new JSElementType("MODULE_KEYWORD");
    public static final IElementType GLOBAL_KEYWORD = new JSElementType("GLOBAL_KEYWORD");
    public static final IElementType DECLARE_KEYWORD = new JSElementType("DECLARE_KEYWORD");
    public static final IElementType REQUIRE_KEYWORD = new JSElementType("REQUIRE_KEYWORD");
    public static final IElementType NUMBER_KEYWORD = new JSElementType("NUMBER_KEYWORD");
    public static final IElementType STRING_KEYWORD = new JSElementType("STRING_KEYWORD");
    public static final IElementType BOOLEAN_KEYWORD = new JSElementType("BOOLEAN_KEYWORD");
    public static final IElementType ANY_KEYWORD = new JSElementType("ANY_KEYWORD");
    public static final IElementType SYMBOL_KEYWORD = new JSElementType("SYMBOL_KEYWORD");
    public static final IElementType FROM_KEYWORD = new JSElementType("FROM_KEYWORD");
    public static final IElementType ABSTRACT_KEYWORD = new JSElementType("ABSTRACT_KEYWORD");
    public static final IElementType READONLY_KEYWORD = new JSElementType("READONLY_KEYWORD");
    public static final IElementType NAMESPACE_KEYWORD = new JSElementType("NAMESPACE_KEYWORD");
    public static final IElementType EXTENDS_KEYWORD = new JSElementType("EXTENDS_KEYWORD");
    public static final IElementType IMPLEMENTS_KEYWORD = new JSElementType("IMPLEMENTS_KEYWORD");
    public static final IElementType USE_KEYWORD = new JSElementType("USE_KEYWORD");
    public static final IElementType PRIVATE_KEYWORD = new JSElementType("PRIVATE_KEYWORD");
    public static final IElementType PROTECTED_KEYWORD = new JSElementType("PROTECTED_KEYWORD");
    public static final IElementType OVERRIDE_KEYWORD = new JSElementType("OVERRIDE_KEYWORD");
    public static final IElementType SUPER_KEYWORD = new JSElementType("SUPER_KEYWORD");
    public static final IElementType INCLUDE_KEYWORD = new JSElementType("INCLUDE_KEYWORD");
    public static final IElementType IS_KEYWORD = new JSElementType("IS_KEYWORD");
    public static final IElementType AS_KEYWORD = new JSElementType("AS_KEYWORD");
    public static final IElementType GET_KEYWORD = new JSElementType("GET_KEYWORD");
    public static final IElementType SET_KEYWORD = new JSElementType("SET_KEYWORD");
    public static final IElementType EACH_KEYWORD = new JSElementType("EACH_KEYWORD");
    public static final IElementType INT_KEYWORD = new JSElementType("INT_KEYWORD");
    public static final IElementType UINT_KEYWORD = new JSElementType("UINT_KEYWORD");
    public static final IElementType ASYNC_KEYWORD = new JSElementType("ASYNC_KEYWORD");
    public static final IElementType MIXED_KEYWORD = new JSElementType("MIXED_KEYWORD");
    public static final IElementType XML_START_TAG_START = XmlTokenType.XML_START_TAG_START;
    public static final IElementType XML_START_TAG_LIST = new JSElementType("XML_TAG__LIST_START");
    public static final IElementType XML_END_TAG_LIST = new JSElementType("XML_TAG__LIST_END");
    public static final IElementType XML_END_TAG_START = XmlTokenType.XML_END_TAG_START;
    public static final IElementType XML_EMPTY_TAG_END = XmlTokenType.XML_EMPTY_ELEMENT_END;
    public static final IElementType XML_NAME = XmlTokenType.XML_NAME;
    public static final IElementType XML_TAG_NAME = XmlTokenType.XML_TAG_NAME;
    public static final IElementType XML_ATTR_EQUAL = XmlTokenType.XML_EQ;
    public static final IElementType XML_TAG_END = XmlTokenType.XML_TAG_END;
    public static final IElementType XML_ATTR_VALUE = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    public static final IElementType XML_ATTR_VALUE_START = XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
    public static final IElementType XML_ATTR_VALUE_END = XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
    public static final IElementType XML_JS_SCRIPT = new JSChameleonElementType("XML_JS_SCRIPT"){

        @Override
        protected void doParse(PsiBuilder builder) {
            JSLanguageDialect dialect = (JSLanguageDialect)((Object)builder.getUserData(JavaScriptParserBase.JS_DIALECT_KEY));
            assert (dialect != null);
            JavaScriptParser<?, ?, ?, ?> parser = dialect.createParser(builder);
            ((ExpressionParser)parser.getExpressionParser()).parseScriptExpression();
        }
    };
    public static final IElementType NON_CHAMELEON_XML_JS_SCRIPT = new JSCompositeElementType("XML_JS_SCRIPT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSEmbeddedContentImpl(node);
        }

        public String toString() {
            return "XML_JS_SCRIPT";
        }
    };
    public static final IElementType XML_TAG_CONTENT = XmlTokenType.XML_DATA_CHARACTERS;
    public static final IElementType XML_ENTITY_REF = XmlTokenType.XML_ENTITY_REF_TOKEN;
    public static final IElementType XML_TAG_WHITE_SPACE = new JSElementType("XML_TAG_WHITESPACE");
    public static final TokenSet XML_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XML_START_TAG_START, XML_START_TAG_LIST, XML_END_TAG_LIST, XML_END_TAG_START, XML_EMPTY_TAG_END, XML_NAME, XML_TAG_NAME, XML_ATTR_EQUAL, XML_ATTR_VALUE, XML_ATTR_VALUE_START, XML_ATTR_VALUE_END, XML_TAG_END, XML_JS_SCRIPT, XML_TAG_CONTENT, XML_STYLE_COMMENT, XML_ENTITY_REF, XML_TAG_WHITE_SPACE});
    public static final IElementType JSP_TEXT = new JSElementType("JSP_TEXT");
    public static final IElementType YIELD_KEYWORD = new JSElementType("YIELD_KEYWORD");
    public static final IElementType LET_KEYWORD = new JSElementType("LET_KEYWORD");
    public static final IElementType TRUE_KEYWORD = new JSElementType("TRUE_KEYWORD");
    public static final IElementType FALSE_KEYWORD = new JSElementType("FALSE_KEYWORD");
    public static final IElementType NULL_KEYWORD = new JSElementType("NULL_KEYWORD");
    public static final IElementType UNDEFINED_KEYWORD = new JSElementType("UNDEFINED_KEYWORD");
    public static final IElementType NUMERIC_LITERAL = new JSElementType("NUMERIC_LITERAL");
    public static final IElementType STRING_LITERAL = new JSElementType("STRING_LITERAL");
    public static final IElementType STRING_LITERAL_PART = new JSElementType("STRING_LITERAL_PART");
    public static final IElementType SINGLE_QUOTE_STRING_LITERAL = new JSElementType("SINGLE_QUOTE_STRING_LITERAL");
    public static final IElementType REGEXP_LITERAL = new JSElementType("REGEXP_LITERAL");
    public static final IElementType STRING_TEMPLATE_PART = new JSElementType("STRING_TEMPLATE_PART");
    public static final IElementType LBRACE = new JSElementType("LBRACE");
    public static final IElementType RBRACE = BaseJSTokenTypes.RBRACE;
    public static final IElementType LPAR = new JSElementType("LPAR");
    public static final IElementType RPAR = new JSElementType("RPAR");
    public static final IElementType LBRACKET = new JSElementType("LBRACKET");
    public static final IElementType RBRACKET = new JSElementType("RBRACKET");
    public static final IElementType DOT = new JSElementType("DOT");
    public static final IElementType SEMICOLON = new JSElementType("SEMICOLON");
    public static final IElementType COMMA = BaseJSTokenTypes.COMMA;
    public static final IElementType LT = new JSElementType("LT");
    public static final IElementType GT = new JSElementType("GT");
    public static final IElementType LE = new JSElementType("LE");
    public static final IElementType GE = new JSElementType("GE");
    public static final IElementType EQEQ = new JSElementType("EQEQ");
    public static final IElementType NE = new JSElementType("NE");
    public static final IElementType EQEQEQ = new JSElementType("EQEQEQ");
    public static final IElementType NEQEQ = new JSElementType("NEQEQ");
    public static final IElementType PLUS = BaseJSTokenTypes.PLUS;
    public static final IElementType MINUS = new JSElementType("MINUS");
    public static final IElementType MULT = new JSElementType("MULT");
    public static final IElementType MULTMULT = new JSElementType("MULTMULT");
    public static final IElementType PERC = new JSElementType("PERC");
    public static final IElementType PLUSPLUS = new JSElementType("PLUSPLUS");
    public static final IElementType MINUSMINUS = new JSElementType("MINUSMINUS");
    public static final IElementType LTLT = new JSElementType("LTLT");
    public static final IElementType GTGT = new JSElementType("GTGT");
    public static final IElementType GTGTGT = new JSElementType("GTGTGT");
    public static final IElementType AND = new JSElementType("AND");
    public static final IElementType OR = new JSElementType("OR");
    public static final IElementType XOR = new JSElementType("XOR");
    public static final IElementType EXCL = new JSElementType("EXCL");
    public static final IElementType TILDE = new JSElementType("TILDE");
    public static final IElementType ANDAND = new JSElementType("ANDAND");
    public static final IElementType AND_AND_EQ = new JSElementType("AND_AND_EQ");
    public static final IElementType OROR = new JSElementType("OROR");
    public static final IElementType OR_OR_EQ = new JSElementType("OR_OR_EQ");
    public static final IElementType QUEST = new JSElementType("QUEST");
    public static final IElementType COLON = new JSElementType("COLON");
    public static final IElementType EQ = new JSEqualElementType();
    public static final IElementType PLUSEQ = new JSElementType("PLUSEQ");
    public static final IElementType MINUSEQ = new JSElementType("MINUSEQ");
    public static final IElementType MULTEQ = new JSElementType("MULTEQ");
    public static final IElementType MULTMULTEQ = new JSElementType("MULTMULTEQ");
    public static final IElementType PERCEQ = new JSElementType("PERCEQ");
    public static final IElementType LTLTEQ = new JSElementType("LTLTEQ");
    public static final IElementType GTGTEQ = new JSElementType("GTGTEQ");
    public static final IElementType GTGTGTEQ = new JSElementType("GTGTGTEQ");
    public static final IElementType ANDEQ = new JSElementType("ANDEQ");
    public static final IElementType OREQ = new JSElementType("OREQ");
    public static final IElementType XOREQ = new JSElementType("XOREQ");
    public static final IElementType DIV = new JSElementType("DIV");
    public static final IElementType DIVEQ = new JSElementType("DIVEQ");
    public static final IElementType BACKQUOTE = new JSElementType("BACKQUOTE");
    public static final IElementType EXEC_STRING_BOUND = new JSElementType("EXEC_STRING_BOUND");
    public static final IElementType DOLLAR = new JSElementType("DOLLAR");
    public static final IElementType EQGT = new JSElementType("EQGT");
    public static final IElementType MINUSGT = new JSElementType("MINUSGT");
    public static final IElementType COLON_COLON = new JSElementType("COLON_COLON");
    public static final IElementType GWT_FIELD_OR_METHOD = new JSElementType("GWT_FIELD_OR_METHOD");
    public static final IElementType DOT_DOT = new JSElementType("DOT_DOT");
    public static final IElementType DOT_DOT_DOT = new JSElementType("DOT_DOT_DOT");
    public static final IElementType GENERIC_SIGNATURE_START = new JSElementType("GENERIC_SIGNATURE_START");
    public static final IElementType AT = new JSElementType("AT");
    public static final IElementType CDATA_START = new JSElementType("CDATA_START");
    public static final IElementType CDATA_END = new JSElementType("CDATA_END");
    public static final IElementType JSDOC_TAG_DATA = new JSElementType("JSDOC_TAG_DATA");
    public static final IElementType JSDOC_MARKUP = new JSElementType("JSDOC_MARKUP");
    public static final IElementType HEREDOC_BOUND = new JSElementType("HEREDOC_BOUND");
    public static final IElementType HEREDOC_BODY = new JSElementType("HEREDOC_BODY");
    public static final IElementType EXEC_BODY = new JSElementType("EXEC_BODY");
    public static final TokenSet ASSOC_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{PLUS, MULT, AND, OR, XOR, OROR, ANDAND});
    public static final TokenSet EQUALITY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{EQEQ, NE, EQEQEQ, NEQEQ});
    public static final TokenSet RELATIONAL_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{LT, GT, LE, GE, INSTANCEOF_KEYWORD, IN_KEYWORD});
    public static final TokenSet ADDITIVE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{PLUS, MINUS});
    public static final TokenSet MULTIPLICATIVE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{MULT, DIV, PERC});
    public static final TokenSet SHIFT_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{LTLT, GTGT, GTGTGT});
    public static final TokenSet UNARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{PLUS, MINUS, PLUSPLUS, MINUSMINUS, TILDE, EXCL, TYPEOF_KEYWORD, VOID_KEYWORD, DELETE_KEYWORD, TYPEOF_KEYWORD, AWAIT_KEYWORD});
    public static final TokenSet ASSIGNMENT_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{EQ, PLUSEQ, MINUSEQ, MULTEQ, PERCEQ, LTLTEQ, GTGTEQ, GTGTGTEQ, ANDEQ, OREQ, XOREQ, DIVEQ, OR_OR_EQ, AND_AND_EQ, MULTMULTEQ});
    public static final TokenSet OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{ASSOC_OPERATIONS, EQUALITY_OPERATIONS, RELATIONAL_OPERATIONS, ADDITIVE_OPERATIONS, MULTIPLICATIVE_OPERATIONS, SHIFT_OPERATIONS, UNARY_OPERATIONS, ASSIGNMENT_OPERATIONS, TokenSet.create((IElementType[])new IElementType[]{QUEST, COLON, COMMA, IS_KEYWORD, AS_KEYWORD, MULTMULT})});
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{END_OF_LINE_COMMENT, DOC_COMMENT, C_STYLE_COMMENT, XML_STYLE_COMMENT, CDATA_START, CDATA_END, XML_STYLE_COMMENT_START, XML_TAG_WHITE_SPACE, JSP_TEXT, JSDOC_TAG_DATA, DOC_COMMENT_TOKEN});
    public static final TokenSet COMMENTS_AND_WHITESPACES = TokenSet.orSet((TokenSet[])new TokenSet[]{COMMENTS, PARSER_WHITE_SPACE_TOKENS});
    public static final TokenSet MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{PUBLIC_KEYWORD, STATIC_KEYWORD, OVERRIDE_KEYWORD, PROTECTED_KEYWORD, PRIVATE_KEYWORD, INTERNAL_KEYWORD, DYNAMIC_KEYWORD, FINAL_KEYWORD, NATIVE_KEYWORD, ASYNC_KEYWORD, VIRTUAL_KEYWORD, EXPORT_KEYWORD, DECLARE_KEYWORD, ABSTRACT_KEYWORD, READONLY_KEYWORD});
    public static final TokenSet ACCESS_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{PUBLIC_KEYWORD, PROTECTED_KEYWORD, PRIVATE_KEYWORD, INTERNAL_KEYWORD});
    public static final TokenSet VAR_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{VAR_KEYWORD, LET_KEYWORD, CONST_KEYWORD});
    public static final TokenSet STRING_LITERALS = TokenSet.create((IElementType[])new IElementType[]{STRING_LITERAL, SINGLE_QUOTE_STRING_LITERAL});
    public static final TokenSet BOOLEAN_LITERALS = TokenSet.create((IElementType[])new IElementType[]{TRUE_KEYWORD, FALSE_KEYWORD});
    public static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{STRING_LITERAL, SINGLE_QUOTE_STRING_LITERAL, NUMERIC_LITERAL, REGEXP_LITERAL});
    public static final TokenSet ARROWS = TokenSet.create((IElementType[])new IElementType[]{EQGT, MINUSGT});
    public static final TokenSet IDENTIFIER_TOKENS_SET = JSKeywordSets.IDENTIFIER_TOKENS_SET;
    public static final TokenSet KEYWORDS = JSKeywordSets.RESERVED_WORDS;

    public static abstract class JSChameleonElementType
    extends ILazyParseableElementType {
        public JSChameleonElementType(@NonNls String name) {
            super(name, (Language)JavascriptLanguage.INSTANCE);
        }

        protected abstract void doParse(PsiBuilder var1);

        public ASTNode parseContents(ASTNode chameleon) {
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            while (parentElement instanceof XmlElement) {
                parentElement = parentElement.getParent();
            }
            Language language = parentElement != null ? parentElement.getLanguage() : null;
            JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
            JSLanguageDialect dialect = language instanceof JSLanguageDialect ? (JSLanguageDialect)language : (configuration != null ? configuration.getLanguageLevel().getDialect() : JSLanguageLevel.DEFAULT.getDialect());
            PsiBuilder builder = factory.createBuilder(project, chameleon, this.createLexer(), (Language)dialect, (CharSequence)chameleon.getText());
            builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)dialect);
            this.doParse(builder);
            return builder.getTreeBuilt();
        }

        protected Lexer createLexer() {
            return null;
        }
    }
}

