/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSShowTypeInfoAction
extends ExpressionTypeProvider<JSElement> {
    @NotNull
    public String getInformationHint(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getInformationHint"));
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)element);
        } else if (element instanceof JSVariable) {
            type = ((JSVariable)element).getType();
        }
        String string = XmlStringUtil.escapeString((String)JSBundle.message((String)"js.show.type.info.action.message", (Object[])new Object[]{JSTypeUtils.getNonEmptyPresentableType(type)}));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getInformationHint"));
        }
        return string;
    }

    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getErrorHint"));
        }
        return string;
    }

    @NotNull
    public List<JSElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getExpressionsAt"));
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(JSElement.class).filter((Condition)new Condition<JSElement>(){

            public boolean value(JSElement o) {
                return o instanceof JSExpression && !(o instanceof JSFunctionExpression) || o instanceof JSVariable;
            }
        }).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getExpressionsAt"));
        }
        return list;
    }
}

