/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BowerAvailablePackagesManager {
    private static final Logger LOG = Logger.getInstance(BowerAvailablePackagesManager.class);
    private static final BowerAvailablePackagesManager INSTANCE = new BowerAvailablePackagesManager();
    private volatile WeakReference<Result> myLastResultRef;
    private final Object myLoadRunLock = new Object();
    private LoadRun myCurrentLoadRun;

    @NotNull
    public static BowerAvailablePackagesManager getInstance() {
        BowerAvailablePackagesManager bowerAvailablePackagesManager = INSTANCE;
        if (bowerAvailablePackagesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getInstance"));
        }
        return bowerAvailablePackagesManager;
    }

    @NotNull
    public List<String> getOrLoadAvailablePackages(@NotNull BowerSettings settings, boolean forceReload) throws IOException {
        List<String> list;
        Result lastResult;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrLoadAvailablePackages"));
        }
        if (!forceReload && (lastResult = (Result)SoftReference.dereference(this.myLastResultRef)) != null && lastResult.mySettings.equals(settings)) {
            List list2 = lastResult.myPackages;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrLoadAvailablePackages"));
            }
            return list2;
        }
        try {
            LoadRun loadRun = this.getOrCreateLoadRun(settings);
            list = loadRun.getFuture().get();
        }
        catch (Exception e) {
            LOG.info("Failed to list all bower packages", (Throwable)e);
            throw new IOException("Failed to list all bower packages", e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrLoadAvailablePackages"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private LoadRun getOrCreateLoadRun(final @NotNull BowerSettings settings) throws ExecutionException {
        FutureTask<List<String>> future;
        LoadRun loadRun;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrCreateLoadRun"));
        }
        Object object = this.myLoadRunLock;
        synchronized (object) {
            loadRun = this.myCurrentLoadRun;
            if (loadRun != null && !loadRun.getSettings().equals(settings)) {
                loadRun.terminate();
                loadRun = null;
            }
            if (loadRun != null) {
                LoadRun loadRun2 = loadRun;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var4_2
                if (loadRun2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrCreateLoadRun"));
                }
                return loadRun2;
            }
            final BowerCommandRun commandRun = BowerCommandLineUtil.startBowerCommand(settings, "search", "--json");
            future = new FutureTask<List<String>>(new Callable<List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<String> call() throws Exception {
                    try {
                        ProcessOutput output = commandRun.captureOutput(TimeUnit.MINUTES.toMillis(10L));
                        List packages = BowerAvailablePackagesManager.parseAllPackages(output.getStdout());
                        BowerAvailablePackagesManager.this.myLastResultRef = new WeakReference<Result>(new Result(settings, packages));
                        List list = packages;
                        return list;
                    }
                    finally {
                        LOG.info("Done 'bower search --json' command");
                        Object object = BowerAvailablePackagesManager.this.myLoadRunLock;
                        synchronized (object) {
                            BowerAvailablePackagesManager.this.myCurrentLoadRun = null;
                        }
                    }
                }
            });
            this.myCurrentLoadRun = loadRun = new LoadRun(settings, commandRun, future);
        }
        future.run();
        LoadRun loadRun3 = loadRun;
        if (loadRun3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "getOrCreateLoadRun"));
        }
        return loadRun3;
    }

    @NotNull
    private static List<String> parseAllPackages(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonContent", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "parseAllPackages"));
        }
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));
        jsonReader.setLenient(false);
        JsonToken topLevelToken = jsonReader.peek();
        if (topLevelToken != JsonToken.BEGIN_ARRAY) {
            LOG.warn("[parse all bower packages] Top-level element should be object, but " + topLevelToken + " found.");
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "parseAllPackages"));
            }
            return list;
        }
        jsonReader.beginArray();
        ArrayList packages = ContainerUtil.newArrayList();
        while (jsonReader.hasNext()) {
            JsonToken childToken = jsonReader.peek();
            if (childToken == JsonToken.BEGIN_OBJECT) {
                String packageName = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"name");
                if (!StringUtil.isNotEmpty((String)packageName)) continue;
                packages.add(packageName);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endArray();
        Collections.sort(packages);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)packages);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager", "parseAllPackages"));
        }
        return immutableList;
    }

    private static class LoadRun {
        private final BowerSettings mySettings;
        private final BowerCommandRun myCommandRun;
        private final Future<List<String>> myFuture;

        public LoadRun(@NotNull BowerSettings settings, @NotNull BowerCommandRun commandRun, @NotNull Future<List<String>> future) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun", "<init>"));
            }
            if (commandRun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandRun", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun", "<init>"));
            }
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun", "<init>"));
            }
            this.mySettings = settings;
            this.myCommandRun = commandRun;
            this.myFuture = future;
        }

        @NotNull
        public BowerSettings getSettings() {
            BowerSettings bowerSettings = this.mySettings;
            if (bowerSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun", "getSettings"));
            }
            return bowerSettings;
        }

        @NotNull
        public Future<List<String>> getFuture() {
            Future<List<String>> future = this.myFuture;
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun", "getFuture"));
            }
            return future;
        }

        public void terminate() {
            this.myCommandRun.terminate();
        }
    }

    private static class Result {
        private final BowerSettings mySettings;
        private final List<String> myPackages;

        private Result(@NotNull BowerSettings settings, @NotNull List<String> packages) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$Result", "<init>"));
            }
            if (packages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$Result", "<init>"));
            }
            this.mySettings = settings;
            this.myPackages = packages;
        }
    }
}

