/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerInstalledPackagesPanel;
import com.intellij.lang.javascript.bower.BowerPackagingService;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerValidationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class BowerPackagesView {
    private static final Logger LOG = Logger.getInstance(BowerPackagesView.class);
    private final Project myProject;
    private final BowerInstalledPackagesPanel myPackagesPanel;
    private final PackagesNotificationPanel myPackagesNotificationPanel;
    private final JPanel myComponent;
    private BowerSettings myCurrentSettings;

    public BowerPackagesView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerPackagesView", "<init>"));
        }
        this.myProject = project;
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Dependencies", (boolean)false));
        this.myPackagesNotificationPanel = new PackagesNotificationPanel();
        this.myPackagesPanel = new BowerInstalledPackagesPanel(project, this.myPackagesNotificationPanel);
        panel.add((Component)((Object)this.myPackagesPanel), "Center");
        panel.add((Component)this.myPackagesNotificationPanel.getComponent(), "South");
        this.myComponent = panel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackagesView", "getComponent"));
        }
        return jPanel;
    }

    public void onSettingsChanged(@NotNull BowerSettings settings, @NotNull List<BowerValidationInfo> errors) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerPackagesView", "onSettingsChanged"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/bower/BowerPackagesView", "onSettingsChanged"));
        }
        if (settings.equals(this.myCurrentSettings)) {
            return;
        }
        this.myCurrentSettings = settings;
        BowerPackagingService service = null;
        this.myPackagesNotificationPanel.hide();
        this.myPackagesNotificationPanel.removeAllLinkHandlers();
        if (errors.isEmpty()) {
            service = new BowerPackagingService(this.myProject, settings);
            this.checkVersion(settings);
        } else {
            this.showErrors(errors);
        }
        this.myPackagesPanel.updatePackages((PackageManagementService)service);
    }

    private void showErrors(@NotNull List<BowerValidationInfo> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/bower/BowerPackagesView", "showErrors"));
        }
        List errorHtmlDescriptions = ContainerUtil.map(errors, (Function)new Function<BowerValidationInfo, String>(){

            public String fun(BowerValidationInfo info) {
                return info.getErrorHtmlDescription();
            }
        });
        String styleTag = UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont());
        String html = "<html>" + styleTag + "<body><div style='padding-left:4px;'>" + StringUtil.join((Collection)errorHtmlDescriptions, (String)"<div style='padding-top:2px;'/>") + "</div></body></html>";
        for (BowerValidationInfo error : errors) {
            String linkText = error.getLinkText();
            final Component component = error.getComponent();
            if (linkText == null || component == null) continue;
            this.myPackagesNotificationPanel.addLinkHandler(linkText, new Runnable(){

                @Override
                public void run() {
                    component.requestFocus();
                }
            });
        }
        this.myPackagesNotificationPanel.showError(html, null, null);
    }

    private void checkVersion(final @NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerPackagesView", "checkVersion"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessOutput output = BowerCommandLineUtil.runBowerCommand(settings, "--version");
                    SemVer semVer = SemVer.parseFromText((String)output.getStdout().trim());
                    if (semVer != null && semVer.getMajor() < 1) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                BowerPackagesView.this.myPackagesNotificationPanel.showError("To view bower packages you need bower@1.0.0 or higher", null, null);
                            }
                        });
                    }
                }
                catch (ExecutionException e) {
                    LOG.warn("Cannot fetch bower version", (Throwable)e);
                }
            }
        });
    }
}

