/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.base.Splitter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerAvailablePackagesManager;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerInstalledPackage;
import com.intellij.lang.javascript.bower.BowerInstalledPackagesParser;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerPackageInfoManager;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackagingService
extends PackageManagementServiceEx {
    private static final Logger LOG = Logger.getInstance(BowerPackagingService.class);
    private final Project myProject;
    private final BowerSettings mySettings;
    private final BowerPackageInfoManager myPackageInfoManager;

    public BowerPackagingService(@NotNull Project project, @NotNull BowerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerPackagingService", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerPackagingService", "<init>"));
        }
        this.myProject = project;
        this.mySettings = settings;
        this.myPackageInfoManager = new BowerPackageInfoManager(settings);
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = this.mySettings;
        if (bowerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackagingService", "getSettings"));
        }
        return bowerSettings;
    }

    public List<RepoPackage> getAllPackages() throws IOException {
        return this.doGetPackages(false);
    }

    public List<RepoPackage> reloadAllPackages() throws IOException {
        return this.doGetPackages(true);
    }

    private List<RepoPackage> doGetPackages(boolean forceReload) throws IOException {
        List<String> packages = BowerAvailablePackagesManager.getInstance().getOrLoadAvailablePackages(this.mySettings, forceReload);
        return ContainerUtil.map(packages, (Function)new Function<String, RepoPackage>(){

            public RepoPackage fun(String packageName) {
                return new RepoPackage(packageName, "");
            }
        });
    }

    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        try {
            ProcessOutput output = this.runCommand("list", "--json");
            List<InstalledPackage> packages = BowerInstalledPackagesParser.parse(output.getStdout());
            return packages;
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public void installPackage(final RepoPackage repoPackage, final @Nullable String version, boolean forceUpgrade, final @Nullable String extraOptions, final PackageManagementService.Listener listener, boolean installToUser) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                BowerPackagingService.this.doInstallPackage(repoPackage.getName(), version, extraOptions, listener);
            }
        });
    }

    private void doInstallPackage(@NotNull String packageName, @Nullable String version, @Nullable String extraOptions, @NotNull PackageManagementService.Listener listener) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerPackagingService", "doInstallPackage"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/bower/BowerPackagingService", "doInstallPackage"));
        }
        listener.operationStarted(packageName);
        String endpoint = packageName;
        if (version != null) {
            endpoint = endpoint + "#" + version;
        }
        if (extraOptions == null) {
            extraOptions = "--save";
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"install", endpoint});
        if (!extraOptions.trim().isEmpty()) {
            Iterable extraArgs = Splitter.on((String)" ").trimResults().split((CharSequence)extraOptions);
            ContainerUtil.addAll((Collection)args, (Iterable)extraArgs);
        }
        try {
            String[] argArray = ArrayUtil.toStringArray((Collection)args);
            ProcessOutput output = this.runCommand(argArray);
            LOG.info("Package installation output: " + output.getStdout());
            listener.operationFinished(packageName, null);
            this.refreshBowerComponents();
        }
        catch (ExecutionException e) {
            listener.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
        }
    }

    private void refreshBowerComponents() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile bowerJsonDir;
                        VirtualFile rootDir = BowerPackagingService.this.myProject.getBaseDir();
                        VirtualFile bowerJson = VfsUtil.findFileByIoFile((File)new File(BowerPackagingService.this.mySettings.getBowerJsonPath()), (boolean)false);
                        if (bowerJson != null && bowerJson.isValid() && (bowerJsonDir = bowerJson.getParent()) != null && bowerJsonDir.isDirectory() && bowerJsonDir.isValid()) {
                            rootDir = bowerJsonDir;
                        }
                        rootDir.refresh(true, true);
                    }
                });
            }
        });
    }

    public void uninstallPackages(List<InstalledPackage> installedPackages, PackageManagementService.Listener listener) {
        ArrayList bowerInstalledPackages = ContainerUtil.newArrayList();
        for (InstalledPackage installedPackage : installedPackages) {
            BowerInstalledPackage pkg = (BowerInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, BowerInstalledPackage.class));
            if (pkg == null) continue;
            bowerInstalledPackages.add(pkg);
        }
        this.uninstallBowerPackages(bowerInstalledPackages, listener);
    }

    private void uninstallBowerPackages(final @NotNull List<BowerInstalledPackage> packages, final @NotNull PackageManagementService.Listener listener) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/lang/javascript/bower/BowerPackagingService", "uninstallBowerPackages"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/bower/BowerPackagingService", "uninstallBowerPackages"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (BowerInstalledPackage pkg : packages) {
                    BowerPackagingService.this.doUninstallPackage(pkg, listener, true);
                }
            }
        });
    }

    private void doUninstallPackage(BowerInstalledPackage pkg, PackageManagementService.Listener listener, boolean refreshFsOnFinish) {
        listener.operationStarted(pkg.getName());
        try {
            this.runCommand("uninstall", "--save", pkg.getName());
            listener.operationFinished(pkg.getName(), null);
            if (refreshFsOnFinish) {
                this.refreshBowerComponents();
            }
        }
        catch (ExecutionException e) {
            listener.operationFinished(pkg.getName(), PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
        }
    }

    public void fetchPackageVersions(String packageName, final CatchingConsumer<List<String>, Exception> consumer) {
        this.myPackageInfoManager.fetchPackageInfo(new BowerPackageInfoManager.PackageInfoConsumer(packageName, true){

            @Override
            public void onPackageInfo(@Nullable BowerPackageInfo packageInfo) {
                List<Object> versions = Collections.emptyList();
                if (packageInfo != null) {
                    versions = packageInfo.getVersions();
                }
                consumer.consume(versions);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/bower/BowerPackagingService$5", "onException"));
                }
                consumer.consume((Throwable)e);
            }
        });
    }

    public void fetchPackageDetails(String packageName, final CatchingConsumer<String, Exception> consumer) {
        this.myPackageInfoManager.fetchPackageInfo(new BowerPackageInfoManager.PackageInfoConsumer(packageName, true){

            @Override
            public void onPackageInfo(@Nullable BowerPackageInfo packageInfo) {
                String html = "<html><body>No description available</</body></html>";
                if (packageInfo != null) {
                    html = packageInfo.formatHtmlDescription();
                }
                consumer.consume((Object)html);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/bower/BowerPackagingService$6", "onException"));
                }
                consumer.consume((Throwable)e);
            }
        });
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, final @Nullable String version, final @NotNull PackageManagementService.Listener listener) {
        if (installedPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedPackage", "com/intellij/lang/javascript/bower/BowerPackagingService", "updatePackage"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/bower/BowerPackagingService", "updatePackage"));
        }
        final BowerInstalledPackage pkg = (BowerInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, BowerInstalledPackage.class));
        if (pkg != null) {
            final String packageName = pkg.getName();
            listener.operationStarted(packageName);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final Ref errorDescriptionRef = Ref.create();
                    PackageManagementService.Listener innerListener = new PackageManagementService.Listener(){

                        public void operationStarted(String packageName) {
                        }

                        public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            errorDescriptionRef.set((Object)errorDescription);
                        }
                    };
                    listener.operationStarted(packageName);
                    BowerPackagingService.this.doUninstallPackage(pkg, innerListener, false);
                    if (errorDescriptionRef.get() != null) {
                        listener.operationFinished(packageName, (PackageManagementService.ErrorDescription)errorDescriptionRef.get());
                    } else {
                        BowerPackagingService.this.doInstallPackage(packageName, version, "--save", innerListener);
                        listener.operationFinished(packageName, (PackageManagementService.ErrorDescription)errorDescriptionRef.get());
                    }
                }
            });
        }
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/lang/javascript/bower/BowerPackagingService", "fetchLatestVersion"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/bower/BowerPackagingService", "fetchLatestVersion"));
        }
        String latestVersion = null;
        if (pkg instanceof BowerInstalledPackage) {
            BowerInstalledPackage bowerPkg = (BowerInstalledPackage)pkg;
            latestVersion = bowerPkg.getLatestVersion();
        }
        consumer.consume(latestVersion);
    }

    @NotNull
    public ProcessOutput runCommand(String ... commands) throws ExecutionException {
        ProcessOutput processOutput = BowerCommandLineUtil.runBowerCommand(this.mySettings, commands);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackagingService", "runCommand"));
        }
        return processOutput;
    }
}

