/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtUtil {
    private static final char BELL = '\u0007';
    private static final String BELL_STR = String.valueOf('\u0007');
    private static final char EIGHTH_NOTE = '\u266a';

    private JsbtUtil() {
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        ArrayList buildfiles = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (webModulesOnly && !WebModuleTypeBase.isWebModule((Module)module)) continue;
            for (VirtualFile parent : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile buildfile = JsbtUtil.detectBuildfile(parent, filenamePrefix, filenameExtensions);
                if (buildfile == null) continue;
                if (buildfiles == null) {
                    buildfiles = ContainerUtil.newArrayList();
                }
                buildfiles.add(buildfile);
            }
        }
        List list = ContainerUtil.notNullize(buildfiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @Nullable
    private static VirtualFile detectBuildfile(@NotNull VirtualFile dir, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        VirtualFile result = null;
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isValid() || child.isDirectory() || !JsbtUtil.isFilenameMatched(child.getNameSequence(), filenamePrefix, filenameExtensions)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            if (JsbtUtil.compareExt(child, result, filenameExtensions) >= 0) continue;
            result = child;
        }
        return result;
    }

    private static int compareExt(@NotNull VirtualFile file1, @NotNull VirtualFile file2, @NotNull String[] extensions) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        int ind1 = ArrayUtil.find((Object[])extensions, (Object)file1.getExtension());
        int ind2 = ArrayUtil.find((Object[])extensions, (Object)file2.getExtension());
        if (ind1 < 0) {
            ind1 = extensions.length;
        }
        if (ind2 < 0) {
            ind2 = extensions.length;
        }
        return ind1 - ind2;
    }

    public static boolean isFilenameMatched(@NotNull CharSequence fileName, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (JsbtUtil.startsWithIgnoreCase(fileName, filenamePrefix)) {
            for (String ext : filenameExtensions) {
                if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)ext)) continue;
                return ext.length() < fileName.length() && '.' == fileName.charAt(fileName.length() - ext.length() - 1);
            }
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull CharSequence text, @NonNls @NotNull CharSequence prefix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "startsWithIgnoreCase"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "startsWithIgnoreCase"));
        }
        int prefixLength = prefix.length();
        if (text.length() < prefixLength) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (StringUtil.charsEqualIgnoreCase((char)text.charAt(i), (char)prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfiles(final @NotNull Project project, final @NotNull String filenamePrefix, final @NotNull String[] filenameExtensions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (DumbService.isDumb((Project)project)) {
            List<VirtualFile> list = JsbtUtil.detectAllBuildfilesInContentRoots(project, false, filenamePrefix, filenameExtensions);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
            }
            return list;
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<VirtualFile>>(){

            public List<VirtualFile> compute() {
                String[] filenames;
                HashSet files = ContainerUtil.newHashSet();
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
                for (String filename : filenames = FilenameIndex.getAllFilenames((Project)project)) {
                    if (!JsbtUtil.isFilenameMatched(filename, filenamePrefix, filenameExtensions)) continue;
                    files.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)filename, (GlobalSearchScope)scope));
                }
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                return ContainerUtil.filter((Collection)files, (Condition)new Condition<VirtualFile>(){

                    public boolean value(VirtualFile virtualFile) {
                        if (virtualFile == null || !virtualFile.isValid() || virtualFile.isDirectory()) {
                            return false;
                        }
                        if (JSLibraryUtil.isProbableLibraryFile(virtualFile)) {
                            return false;
                        }
                        return !fileIndex.isInLibraryClasses(virtualFile) && !fileIndex.isInLibrarySource(virtualFile);
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        return list;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        if (!project.isDisposed() && (root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file)) != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        return string;
    }

    public static void foldMatchingTextAtOffset(@NotNull ConsoleView consoleView, final int matchingTextDocumentStartOffset, final @NotNull String matchingText, final @NotNull String foldedText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        if (matchingText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        if (foldedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        final ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)ObjectUtils.tryCast((Object)consoleView, ConsoleViewImpl.class);
        if (consoleViewImpl == null) {
            return;
        }
        consoleViewImpl.flushDeferredText();
        consoleViewImpl.performWhenNoDeferredOutput(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                Document document = consoleViewImpl.getEditor().getDocument();
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)matchingTextDocumentStartOffset, (CharSequence)matchingText)) {
                    final FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
                    foldingModel.runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            FoldRegion region = foldingModel.addFoldRegion(matchingTextDocumentStartOffset, matchingTextDocumentStartOffset + matchingText.length(), foldedText);
                            if (region != null) {
                                region.setExpanded(false);
                            }
                        }
                    });
                }
            }
        });
    }

    public static boolean equalsOrderless(@NotNull List<String> a, @NotNull List<String> b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "equalsOrderless"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "equalsOrderless"));
        }
        if (a.size() <= 1 || b.size() <= 1) {
            return a.equals(b);
        }
        List<String> as = JsbtUtil.sort(a);
        List<String> bs = JsbtUtil.sort(b);
        return as.equals(bs);
    }

    @NotNull
    private static List<String> sort(@NotNull List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "sort"));
        }
        Object[] array = ArrayUtil.toStringArray(list);
        Arrays.sort(array);
        List<Object> list2 = Arrays.asList(array);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "sort"));
        }
        return list2;
    }

    @Nullable
    public static JsbtInvalidSetting validatePackageDir(@NotNull String packageDir, @NotNull String name, @NotNull String packageName) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (StringUtil.isEmptyOrSpaces((String)packageDir)) {
            return new JsbtInvalidSetting(name, packageDir, "Please specify " + packageName + " package");
        }
        File dir = new File(packageDir);
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            return new JsbtInvalidSetting(name, packageDir, "Please specify " + packageName + " package directory correctly");
        }
        return null;
    }

    @NotNull
    public static ProcessHandler createProcessHandlerWithBeepSupport(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "createProcessHandlerWithBeepSupport"));
        }
        KillableColoredProcessHandler killableColoredProcessHandler = new KillableColoredProcessHandler(commandLine, true){
            private boolean myPreviousBellChar = false;

            public void coloredTextAvailable(String text, Key attributes) {
                if (text != null && ProcessOutputTypes.SYSTEM != attributes && ProcessOutputTypes.STDERR != attributes) {
                    boolean bellCharFound = false;
                    for (int i = 0; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (this.myPreviousBellChar && ch == '\u266a') {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            });
                        }
                        boolean bellChar = ch == '\u0007';
                        bellCharFound |= bellChar;
                        this.myPreviousBellChar = bellChar;
                    }
                    if (bellCharFound) {
                        text = StringUtil.replace((String)text, (String)BELL_STR, (String)"");
                    }
                }
                super.coloredTextAvailable(text, attributes);
            }
        };
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "createProcessHandlerWithBeepSupport"));
        }
        return killableColoredProcessHandler;
    }

    public static List<String> encodeNames(@NotNull List<String> rawNames) {
        if (rawNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawNames", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "encodeNames"));
        }
        return ContainerUtil.map(rawNames, (Function)new Function<String, String>(){

            public String fun(String name) {
                return ParametersListUtil.join(Collections.singletonList(name));
            }
        });
    }
}

