/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskListingSettingsDialog;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskTreeView;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(GruntService.class);
    private static GruntService INSTANCE;
    private static final String GRUNTFILE_NAME_WITHOUT_EXT = "Gruntfile";
    private static final String[] KNOWN_EXTENSIONS;

    @NotNull
    public static GruntService getInstance() {
        GruntService instance = INSTANCE;
        if (instance == null) {
            instance = (GruntService)JsbtService.EP_NAME.findExtension(GruntService.class);
            if (instance == null) {
                LOG.error("Cannot find extension " + JsbtService.EP_NAME.getName() + " of class " + GruntService.class.getName());
                instance = new GruntService();
            }
            INSTANCE = instance;
        }
        GruntService gruntService = instance;
        if (gruntService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "getInstance"));
        }
        return gruntService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Grunt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "getName"));
        }
        return "Grunt";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Grunt.Grunt;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "getFileManager"));
        }
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(project);
        if (gruntfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "getFileManager"));
        }
        return gruntfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createToolWindowManager"));
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "Grunt ", JavaScriptLanguageIcons.Grunt.Grunt_toolwindow, "reference.tool.window.grunt", this);
        if (jsbtToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createToolWindowManager"));
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createTaskTreeView"));
        }
        GruntTaskTreeView gruntTaskTreeView = new GruntTaskTreeView(this, project, layoutPlace);
        if (gruntTaskTreeView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createTaskTreeView"));
        }
        return gruntTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "detectAllBuildfiles"));
        }
        List<VirtualFile> list = JsbtUtil.detectAllBuildfiles(project, GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "detectAllBuildfiles"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "detectAllBuildfilesInContentRoots"));
        }
        List<VirtualFile> list = JsbtUtil.detectAllBuildfilesInContentRoots(project, webModulesOnly, GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @Override
    public String getBuildfileCommonName() {
        return GRUNTFILE_NAME_WITHOUT_EXT;
    }

    @Override
    public boolean isBuildfileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "isBuildfileName"));
        }
        return JsbtUtil.isFilenameMatched(fileName, GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createEmptyFileStructure"));
        }
        GruntfileStructure gruntfileStructure = new GruntfileStructure(buildfile);
        if (gruntfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "createEmptyFileStructure"));
        }
        return gruntfileStructure;
    }

    @Override
    @NotNull
    public GruntfileStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile gruntfile) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "fetchBuildfileStructure"));
        }
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "fetchBuildfileStructure"));
        }
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreter interpreter = templateRunSettings.getInterpreterRef().resolve(project);
        GruntNonSharedSettings settings = GruntNonSharedSettingsManager.getInstance(project).get(interpreter, gruntfile);
        try {
            gruntfileStructure = GruntTaskStructureUtil.fetchStructure(interpreter, templateRunSettings.getNodeOptions(), settings.getGruntCliPackageDirPath(), gruntfile, templateRunSettings.getEnvData());
        }
        catch (JsbtTaskFetchException e) {
            String description = e.getDescription();
            LOG.info(description);
            throw e;
        }
        if (gruntfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "fetchBuildfileStructure"));
        }
        return gruntfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GruntConfigurationType.getFactory();
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "getConfigurationFactory"));
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "isConfigurationMatched"));
        }
        if (patternObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternObject", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "isConfigurationMatched"));
        }
        if (runConfiguration instanceof GruntRunConfiguration) {
            GruntRunSettings runSettings = ((GruntRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                if (JsbtUtil.equalsOrderless(runSettings.getTasks(), patternTaskSet.getTaskNames())) {
                    String systemIndependentPath = patternTaskSet.getStructure().getBuildfile().getPath();
                    return systemIndependentPath.equals(FileUtil.toSystemIndependentName((String)runSettings.getGruntfilePath()));
                }
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "setupRunConfiguration"));
        }
        if (taskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "setupRunConfiguration"));
        }
        GruntfileStructure structure = (GruntfileStructure)taskSet.getStructure();
        GruntRunConfiguration gruntRunConfiguration = (GruntRunConfiguration)runConfiguration;
        GruntRunSettings merged = new GruntRunSettings.Builder(gruntRunConfiguration.getRunSettings()).setGruntfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GruntRunConfigurationProducer.setupConfigurationFromSettings(gruntRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "showTaskListingSettingsDialog"));
        }
        return new GruntTaskListingSettingsDialog(project, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntService", "detectFirstBuildfileInContentRoots"));
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }

    static {
        KNOWN_EXTENSIONS = new String[]{"coffee", "js"};
    }
}

