/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntfilePsiStructure {
    private static final Key<CachedValue<GruntfilePsiStructure>> KEY = Key.create((String)GruntfilePsiStructure.class.getName());
    private final Map<String, JSProperty> myConfigByKeyMap;
    private final Map<String, JSCallExpression> myTaskBodyByNameMap;

    public GruntfilePsiStructure(@NotNull Map<String, JSProperty> configurationByKeyMap, @NotNull Map<String, JSCallExpression> taskBodyByNameMap) {
        if (configurationByKeyMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationByKeyMap", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "<init>"));
        }
        if (taskBodyByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskBodyByNameMap", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "<init>"));
        }
        this.myConfigByKeyMap = ImmutableMap.copyOf(configurationByKeyMap);
        this.myTaskBodyByNameMap = ImmutableMap.copyOf(taskBodyByNameMap);
    }

    @Nullable
    public PsiElement getPsiElementToNavigateTo(@NotNull String taskName, @Nullable String targetName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "getPsiElementToNavigateTo"));
        }
        if (targetName != null) {
            JSProperty config = this.myConfigByKeyMap.get(taskName);
            if (config != null) {
                JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)config.getValue(), JSObjectLiteralExpression.class);
                return JSPsiUtil.findPropertyByName(objectLiteral, targetName);
            }
            return null;
        }
        JSCallExpression callExpression = this.myTaskBodyByNameMap.get(taskName);
        if (callExpression != null) {
            JSLiteralExpression nameExpr = JSPsiUtil.getFirstArgumentAsStringLiteral(callExpression.getArgumentList());
            if (nameExpr != null && taskName.equals(JSPsiUtil.getStringLiteralValue(nameExpr))) {
                return nameExpr;
            }
            return callExpression;
        }
        return (PsiElement)this.myConfigByKeyMap.get(taskName);
    }

    @NotNull
    public Set<String> getConfigKeys() {
        Set<String> set = this.myConfigByKeyMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "getConfigKeys"));
        }
        return set;
    }

    @NotNull
    public static GruntfilePsiStructure get(final @NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "get"));
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        GruntfilePsiStructure gruntfilePsiStructure = (GruntfilePsiStructure)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, KEY, (CachedValueProvider)new CachedValueProvider<GruntfilePsiStructure>(){

            public CachedValueProvider.Result<GruntfilePsiStructure> compute() {
                GruntfilePsiStructure structure = GruntfilePsiStructure.build(jsFile);
                return CachedValueProvider.Result.create((Object)structure, (Object[])new Object[]{jsFile});
            }
        }, false);
        if (gruntfilePsiStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "get"));
        }
        return gruntfilePsiStructure;
    }

    @NotNull
    private static GruntfilePsiStructure build(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "build"));
        }
        PsiElement[] topLevelElements = file.getChildren();
        HashMap optionsMap = ContainerUtil.newHashMap();
        HashMap taskBodyByNameMap = ContainerUtil.newHashMap();
        for (PsiElement topLevelElement : topLevelElements) {
            JSFunctionExpression body;
            JSExpressionStatement expressionStatement;
            JSAssignmentExpression assignmentExpression;
            if (!(topLevelElement instanceof JSExpressionStatement) || (assignmentExpression = (JSAssignmentExpression)ObjectUtils.tryCast((Object)(expressionStatement = (JSExpressionStatement)topLevelElement).getExpression(), JSAssignmentExpression.class)) == null || !GruntfilePsiStructure.isModuleExports(assignmentExpression.getLOperand()) || (body = (JSFunctionExpression)ObjectUtils.tryCast((Object)assignmentExpression.getROperand(), JSFunctionExpression.class)) == null) continue;
            List statements = JsPsiUtils.listStatementsInExecutionOrder((JSFunctionExpression)body);
            GruntfilePsiStructure.fillOptionsMap(optionsMap, statements);
            GruntfilePsiStructure.fillTasks(taskBodyByNameMap, statements);
        }
        GruntfilePsiStructure gruntfilePsiStructure = new GruntfilePsiStructure(optionsMap, taskBodyByNameMap);
        if (gruntfilePsiStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "build"));
        }
        return gruntfilePsiStructure;
    }

    private static void fillOptionsMap(@NotNull Map<String, JSProperty> optionsMap, @NotNull List<JSStatement> statements) {
        if (optionsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsMap", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "fillOptionsMap"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "fillOptionsMap"));
        }
        for (JSStatement statement : statements) {
            JSProperty[] properties;
            JSObjectLiteralExpression optionsObj;
            JSReferenceExpression refExpr;
            JSExpressionStatement exprStatement;
            JSCallExpression callExpression;
            if (!(statement instanceof JSExpressionStatement) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(exprStatement = (JSExpressionStatement)statement).getExpression(), JSCallExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) == null || !"initConfig".equals(refExpr.getReferenceName()) || (optionsObj = JSPsiUtil.getFirstArgumentAsObjectLiteral(callExpression.getArgumentList())) == null) continue;
            for (JSProperty property : properties = JSPsiUtil.getProperties(optionsObj)) {
                optionsMap.put(property.getName(), property);
            }
        }
    }

    private static void fillTasks(@NotNull Map<String, JSCallExpression> taskBodyByNameMap, @NotNull List<JSStatement> statements) {
        if (taskBodyByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskBodyByNameMap", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "fillTasks"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "fillTasks"));
        }
        for (JSStatement statement : statements) {
            String name;
            JSReferenceExpression refExpr;
            JSExpressionStatement exprStatement;
            JSCallExpression callExpression;
            if (!(statement instanceof JSExpressionStatement) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(exprStatement = (JSExpressionStatement)statement).getExpression(), JSCallExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) == null || !GruntfilePsiStructure.isRegisterTaskName(refExpr) || (name = JSPsiUtil.getFirstArgumentAsString(callExpression.getArgumentList())) == null) continue;
            taskBodyByNameMap.put(name, callExpression);
        }
    }

    private static boolean isRegisterTaskName(@NotNull JSReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure", "isRegisterTaskName"));
        }
        String name = refExpr.getReferenceName();
        return "registerTask".equals(name) || "registerMultiTask".equals(name);
    }

    private static boolean isModuleExports(@Nullable JSExpression expression) {
        JSDefinitionExpression defExpr;
        JSReferenceExpression refExpr;
        if (expression instanceof JSDefinitionExpression && (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)(defExpr = (JSDefinitionExpression)expression).getExpression(), JSReferenceExpression.class)) != null && "exports".equals(refExpr.getReferenceName())) {
            JSReferenceExpression refExpr2 = (JSReferenceExpression)ObjectUtils.tryCast((Object)refExpr.getQualifier(), JSReferenceExpression.class);
            return refExpr2 != null && "module".equals(refExpr2.getReferenceName());
        }
        return false;
    }
}

