/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntRunSettings {
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_GRUNTFILE = "gruntfile";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_TASK = "task";
    private static final String TAG_FORCE_EXECUTION = "force";
    private static final String TAG_VERBOSE_MODE = "verbose";
    private static final String TAG_PASS_PARENT_ENV_VARS = "pass-parent-env-vars";
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myGruntfilePath;
    private final String myGruntfileSystemIndependentPath;
    private final List<String> myTasks;
    private final boolean myForceExecution;
    private final boolean myVerboseMode;
    private final EnvironmentVariablesData myEnvData;
    private final boolean myNewEnvFormat;

    public GruntRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myGruntfilePath = FileUtil.toSystemDependentName((String)builder.myGruntfilePath);
        this.myGruntfileSystemIndependentPath = FileUtil.toSystemIndependentName((String)this.myGruntfilePath);
        this.myTasks = ImmutableList.copyOf((Collection)builder.myTasks);
        this.myForceExecution = builder.myForceExecution;
        this.myVerboseMode = builder.myVerboseMode;
        this.myEnvData = builder.myEnvData;
        this.myNewEnvFormat = builder.myNewEnvFormat;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getNodeOptions"));
        }
        return string;
    }

    @NotNull
    public String getGruntfilePath() {
        String string = this.myGruntfilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getGruntfilePath"));
        }
        return string;
    }

    @NotNull
    public String getGruntfileSystemIndependentPath() {
        String string = this.myGruntfileSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getGruntfileSystemIndependentPath"));
        }
        return string;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getTasks"));
        }
        return list;
    }

    public boolean isForceExecution() {
        return this.myForceExecution;
    }

    public boolean isVerboseMode() {
        return this.myVerboseMode;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GruntRunSettings that = (GruntRunSettings)o;
        return this.myNodeOptions.equals(that.myNodeOptions) && this.myGruntfilePath.equals(that.myGruntfilePath) && this.myTasks.equals(that.myTasks) && this.myForceExecution == that.myForceExecution && this.myVerboseMode == that.myVerboseMode && this.myEnvData.equals((Object)that.myEnvData);
    }

    public int hashCode() {
        int result = this.myGruntfilePath.hashCode();
        result = 31 * result + this.myNodeOptions.hashCode();
        result = 31 * result + this.myTasks.hashCode();
        result = 31 * result + (this.myForceExecution ? 1 : 0);
        result = 31 * result + (this.myVerboseMode ? 1 : 0);
        result = 31 * result + this.myEnvData.hashCode();
        return result;
    }

    public void writeToXml(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "writeToXml"));
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_NODE_INTERPRETER, (String)this.myInterpreterRef.getReferenceName());
        if (!this.myNodeOptions.isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_NODE_OPTIONS, (String)this.myNodeOptions);
        }
        if (!this.myGruntfilePath.isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_GRUNTFILE, (String)FileUtil.toSystemIndependentName((String)this.myGruntfilePath));
        }
        this.writeTasks(parent);
        if (this.myNewEnvFormat) {
            this.myEnvData.writeExternal(parent);
        } else {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_PASS_PARENT_ENV_VARS, (String)Boolean.toString(this.myEnvData.isPassParentEnvs()));
            EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)this.myEnvData.getEnvs());
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_FORCE_EXECUTION, (String)Boolean.toString(this.myForceExecution));
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_VERBOSE_MODE, (String)Boolean.toString(this.myVerboseMode));
    }

    private void writeTasks(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "writeTasks"));
        }
        if (this.myTasks.isEmpty()) {
            return;
        }
        Element tasksElement = new Element(TAG_TASKS);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)tasksElement, (String)TAG_TASK, this.myTasks);
        parent.addContent(tasksElement);
    }

    @NotNull
    public static GruntRunSettings readFromXml(@Nullable Element parent) {
        EnvironmentVariablesData envData;
        Builder builder = new Builder();
        if (parent == null) {
            GruntRunSettings gruntRunSettings = builder.build();
            if (gruntRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readFromXml"));
            }
            return gruntRunSettings;
        }
        String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_NODE_INTERPRETER);
        NodeJsInterpreterRef interpreterRef = GruntRunSettings.createInterpreterRef(interpreterRefName);
        builder.setInterpreterRef(interpreterRef);
        builder.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_NODE_OPTIONS)));
        builder.setGruntfilePath(StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_GRUNTFILE)));
        builder.setTasks(GruntRunSettings.readTasks(parent));
        builder.setForceExecution(GruntRunSettings.readBoolean(parent, TAG_FORCE_EXECUTION, false));
        builder.setVerboseMode(GruntRunSettings.readBoolean(parent, TAG_VERBOSE_MODE, false));
        String oldPassParentEnvsStr = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_PASS_PARENT_ENV_VARS);
        if (oldPassParentEnvsStr == null) {
            envData = EnvironmentVariablesData.readExternal((Element)parent);
        } else {
            LinkedHashMap envVars = ContainerUtil.newLinkedHashMap();
            EnvironmentVariablesComponent.readExternal((Element)parent, (Map)envVars);
            envData = EnvironmentVariablesData.create((Map)envVars, (boolean)GruntRunSettings.readBoolean(parent, TAG_PASS_PARENT_ENV_VARS, true));
        }
        builder.myNewEnvFormat = oldPassParentEnvsStr == null;
        builder.setEnvData(envData);
        GruntRunSettings gruntRunSettings = builder.build();
        if (gruntRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readFromXml"));
        }
        return gruntRunSettings;
    }

    private static NodeJsInterpreterRef createInterpreterRef(@Nullable String interpreterRefName) {
        if (interpreterRefName != null) {
            return NodeJsInterpreterRef.create(interpreterRefName);
        }
        return NodeJsInterpreterRef.createProjectRef();
    }

    private static boolean readBoolean(@NotNull Element parent, @NotNull String childTag, boolean defaultValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readBoolean"));
        }
        if (childTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTag", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readBoolean"));
        }
        String value = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)childTag);
        if (Boolean.toString(true).equals(value)) {
            return true;
        }
        if (Boolean.toString(false).equals(value)) {
            return false;
        }
        return defaultValue;
    }

    @NotNull
    private static List<String> readTasks(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readTasks"));
        }
        Element tasksElement = parent.getChild(TAG_TASKS);
        if (tasksElement != null) {
            List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)tasksElement, (String)TAG_TASK);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readTasks"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "readTasks"));
        }
        return list;
    }

    @NotNull
    public static Builder builder(@NotNull GruntRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "builder"));
        }
        Builder builder = new Builder(settings);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myGruntfilePath;
        private List<String> myTasks;
        private boolean myForceExecution;
        private boolean myVerboseMode;
        private EnvironmentVariablesData myEnvData;
        private boolean myNewEnvFormat;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGruntfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myForceExecution = false;
            this.myVerboseMode = false;
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
        }

        public Builder(@NotNull GruntRunSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGruntfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myForceExecution = false;
            this.myVerboseMode = false;
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
            this.myNodeOptions = settings.getNodeOptions();
            this.myGruntfilePath = settings.getGruntfilePath();
            this.myTasks = ImmutableList.copyOf(settings.getTasks());
            this.myEnvData = settings.getEnvData();
            this.myNewEnvFormat = settings.myNewEnvFormat;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@Nullable String nodeOptions) {
            this.myNodeOptions = StringUtil.notNullize((String)nodeOptions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setNodeOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setGruntfilePath(@Nullable String gruntfilePath) {
            this.myGruntfilePath = StringUtil.notNullize((String)gruntfilePath);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setGruntfilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setTasks(@NotNull List<String> tasks) {
            if (tasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GruntRunSettings.TAG_TASKS, "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setTasks"));
            }
            this.myTasks = ImmutableList.copyOf(tasks);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setTasks"));
            }
            return builder;
        }

        @NotNull
        public Builder setForceExecution(boolean forceExecution) {
            this.myForceExecution = forceExecution;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setForceExecution"));
            }
            return builder;
        }

        @NotNull
        public Builder setVerboseMode(boolean verboseMode) {
            this.myVerboseMode = verboseMode;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setVerboseMode"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public GruntRunSettings build() {
            GruntRunSettings gruntRunSettings = new GruntRunSettings(this);
            if (gruntRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder", "build"));
            }
            return gruntRunSettings;
        }
    }
}

