/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListFetchUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskTreeView;
import com.intellij.lang.javascript.buildTools.gulp.GulpTasksFetchSettingsDialog;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(GulpService.class);
    private static final String GULPFILE_NAME_WITHOUT_EXT = "Gulpfile";
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "es6", "js"};
    private static GulpService INSTANCE;

    @NotNull
    public static GulpService getInstance() {
        GulpService instance = INSTANCE;
        if (instance == null) {
            instance = (GulpService)JsbtService.EP_NAME.findExtension(GulpService.class);
            if (instance == null) {
                LOG.error("Cannot find extension " + JsbtService.EP_NAME.getName() + " of class " + GulpService.class.getName());
                instance = new GulpService();
            }
            INSTANCE = instance;
        }
        GulpService gulpService = instance;
        if (gulpService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getInstance"));
        }
        return gulpService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Gulp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getName"));
        }
        return "Gulp";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Gulp16;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getFileManager"));
        }
        GulpfileManager gulpfileManager = GulpfileManager.getInstance(project);
        if (gulpfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getFileManager"));
        }
        return gulpfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createToolWindowManager"));
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "Gulp", JavaScriptLanguageIcons.BuildTools.Gulp_toolwindow, "reference.tool.window.js.build_tools.gulp", this);
        if (jsbtToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createToolWindowManager"));
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createTaskTreeView"));
        }
        GulpTaskTreeView gulpTaskTreeView = new GulpTaskTreeView(this, project, layoutPlace);
        if (gulpTaskTreeView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createTaskTreeView"));
        }
        return gulpTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfiles"));
        }
        List<VirtualFile> list = JsbtUtil.detectAllBuildfiles(project, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfiles"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfilesInContentRoots"));
        }
        List<VirtualFile> list = JsbtUtil.detectAllBuildfilesInContentRoots(project, webModulesOnly, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @Override
    public String getBuildfileCommonName() {
        return GULPFILE_NAME_WITHOUT_EXT;
    }

    @Override
    public boolean isBuildfileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isBuildfileName"));
        }
        return JsbtUtil.isFilenameMatched(fileName, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createEmptyFileStructure"));
        }
        GulpfileStructure gulpfileStructure = new GulpfileStructure(buildfile);
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createEmptyFileStructure"));
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public JsbtFileStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) throws JsbtTaskFetchException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        GulpfileStructure gulpfileStructure = GulpTaskListFetchUtil.listTasks(project, buildfile);
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GulpConfigurationType.getFactory();
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getConfigurationFactory"));
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isConfigurationMatched"));
        }
        if (patternObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternObject", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isConfigurationMatched"));
        }
        if (runConfiguration instanceof GulpRunConfiguration) {
            GulpRunSettings runSettings = ((GulpRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof GulpRunSettings) {
                GulpRunSettings patternRunSettings = (GulpRunSettings)patternObject;
                return JsbtUtil.equalsOrderless(patternRunSettings.getTasks(), runSettings.getTasks()) && patternRunSettings.getGulpfileSystemIndependentPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getTasks()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "setupRunConfiguration"));
        }
        if (taskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "setupRunConfiguration"));
        }
        GulpfileStructure structure = (GulpfileStructure)taskSet.getStructure();
        GulpRunConfiguration gulpRunConfiguration = (GulpRunConfiguration)runConfiguration;
        GulpRunSettings merged = new GulpRunSettings.Builder(gulpRunConfiguration.getRunSettings()).setGulpfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GulpRunConfigurationProducer.setupConfigurationFromSettings(gulpRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "showTaskListingSettingsDialog"));
        }
        return new GulpTasksFetchSettingsDialog(project, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectFirstBuildfileInContentRoots"));
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }
}

