/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.gulp.GulpJsonTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpPseudoGraphicTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParseException;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.CommandLineUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTaskListFetchUtil {
    private static final Logger LOG = Logger.getInstance(GulpTaskListFetchUtil.class);

    private GulpTaskListFetchUtil() {
    }

    @NotNull
    public static GulpfileStructure listTasks(@NotNull Project project, @NotNull VirtualFile gulpfile) throws JsbtTaskFetchException {
        GulpfileStructure gulpfileStructure;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "listTasks"));
        }
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "listTasks"));
        }
        GulpRunSettings templateRunSettings = GulpRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreterRef interpreterRef = templateRunSettings.getInterpreterRef();
        NodeJsInterpreter interpreter = interpreterRef.resolve(project);
        GulpNonSharedSettings nonSharedSettings = GulpNonSharedSettingsManager.getInstance(project).get(interpreter, gulpfile);
        String nodeOptions = templateRunSettings.getNodeOptions();
        EnvironmentVariablesData envData = templateRunSettings.getEnvData();
        try {
            long startTime = System.currentTimeMillis();
            GulpfileStructure structure = GulpTaskListFetchUtil.doListTasks(interpreter, nodeOptions, nonSharedSettings.getGulpPackageDirPath(), gulpfile, envData);
            LOG.info(String.format("%s: %d tasks listed in %d ms", gulpfile.getPath(), structure.getTasks().size(), System.currentTimeMillis() - startTime));
            gulpfileStructure = structure;
        }
        catch (JsbtTaskFetchException e) {
            String description = e.getDescription();
            LOG.info(description);
            throw e;
        }
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "listTasks"));
        }
        return gulpfileStructure;
    }

    @NotNull
    private static List<JsbtInvalidSetting> checkSettings(@Nullable NodeJsInterpreter interpreter, @NotNull String gulpPackageDir) {
        JsbtInvalidSetting gulpPackageErrorInfo;
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "checkSettings"));
        }
        ArrayList errorInfos = ContainerUtil.newArrayList();
        JsbtInvalidSetting nodeInterpreterErrorInfo = GulpTaskListFetchUtil.validateNodeInterpreter(interpreter);
        if (nodeInterpreterErrorInfo != null) {
            errorInfos.add(nodeInterpreterErrorInfo);
        }
        if ((gulpPackageErrorInfo = GulpTaskListFetchUtil.validateGulpPackageDir(gulpPackageDir)) != null) {
            errorInfos.add(gulpPackageErrorInfo);
        }
        ArrayList arrayList = errorInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "checkSettings"));
        }
        return arrayList;
    }

    @Nullable
    private static JsbtInvalidSetting validateNodeInterpreter(@Nullable NodeJsInterpreter interpreter) {
        String name = "Node interpreter";
        String errorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (errorMessage != null) {
            return new JsbtInvalidSetting(name, null, errorMessage);
        }
        return null;
    }

    @Nullable
    private static JsbtInvalidSetting validateGulpPackageDir(@NotNull String gulpPackageDir) {
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "validateGulpPackageDir"));
        }
        String name = "Gulp package";
        if (StringUtil.isEmptyOrSpaces((String)gulpPackageDir)) {
            return new JsbtInvalidSetting(name, gulpPackageDir, "Please specify gulp package");
        }
        File dir = new File(gulpPackageDir);
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            return new JsbtInvalidSetting(name, gulpPackageDir, "Please specify gulp package directory correctly");
        }
        return null;
    }

    @NotNull
    private static GulpfileStructure doListTasks(@Nullable NodeJsInterpreter interpreter, @NotNull String nodeOptions, @NotNull String gulpPackageDir, @NotNull VirtualFile gulpfile, @NotNull EnvironmentVariablesData envData) throws JsbtTaskFetchException {
        GulpfileStructure gulpfileStructure;
        KillableColoredProcessHandler processHandler;
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "doListTasks"));
        }
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "doListTasks"));
        }
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "doListTasks"));
        }
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "doListTasks"));
        }
        List<JsbtInvalidSetting> valueErrorInfos = GulpTaskListFetchUtil.checkSettings(interpreter, gulpPackageDir);
        if (!valueErrorInfos.isEmpty()) {
            throw JsbtTaskFetchException.newInvalidSettings(gulpfile, valueErrorInfos);
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new IllegalStateException("Local Node.js interpreter is required");
        }
        String gulpfilePath = FileUtil.toSystemDependentName((String)gulpfile.getPath());
        NodePackageVersion packageVersion = NodePackageVersionUtil.getPackageVersion(gulpPackageDir);
        boolean jsonOutput = GulpTaskListFetchUtil.isJsonOutputSupported(packageVersion);
        GeneralCommandLine commandLine = GulpTaskListFetchUtil.createTasksFetchCommandLine(localInterpreter, nodeOptions, gulpPackageDir, jsonOutput, gulpfilePath, envData);
        LOG.info("[" + packageVersion + "] Fetching gulp tasks: " + commandLine.getCommandLineString());
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, true);
        }
        catch (ExecutionException e) {
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "cannot execute command", commandLine, e, null, null);
        }
        long startTimeMillis = System.currentTimeMillis();
        ProcessOutput processOutput = GulpTaskListFetchUtil.captureTasksFetchOutput((BaseOSProcessHandler)processHandler, jsonOutput);
        if (processOutput.isTimeout()) {
            long duration = System.currentTimeMillis() - startTimeMillis;
            String message = String.format("timed limit exceeded (%.1f sec), process was terminated forcibly", (double)duration / 1000.0);
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, message, commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        if (processOutput.getExitCode() != 0) {
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "process finished with exit code " + processOutput.getExitCode() + " (a non-zero exit code means an error)", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        try {
            GulpTaskListParser parser = jsonOutput ? GulpJsonTaskListParser.INSTANCE : GulpPseudoGraphicTaskListParser.INSTANCE;
            List<Pair<String, List<String>>> taskList = parser.parseTaskList(processOutput.getStdout());
            gulpfileStructure = GulpTaskListFetchUtil.createStructure(gulpfile, taskList);
        }
        catch (GulpTaskListParseException e) {
            Throwable cause = e.getCause();
            String message = e.getMessage();
            if (cause != null) {
                message = message + " -> " + cause.getMessage();
                LOG.warn(message, (Throwable)e);
            }
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, message, commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse gulp task list output", t);
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "internal problem occurred when parsing output", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "doListTasks"));
        }
        return gulpfileStructure;
    }

    private static boolean isJsonOutputSupported(@Nullable NodePackageVersion packageVersion) {
        if (packageVersion == null) {
            return false;
        }
        if (GulpUtil.isGulpPackage(packageVersion)) {
            SemVer semVer = packageVersion.getSemVer();
            return semVer != null && semVer.getMajor() >= 4;
        }
        return GulpUtil.isGulpCliPackage(packageVersion);
    }

    @NotNull
    private static GulpfileStructure createStructure(@NotNull VirtualFile gulpfile, @NotNull List<Pair<String, List<String>>> taskList) {
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createStructure"));
        }
        if (taskList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskList", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createStructure"));
        }
        final GulpfileStructure structure = new GulpfileStructure(gulpfile);
        List tasks = ContainerUtil.map(taskList, (Function)new Function<Pair<String, List<String>>, GulpTask>(){

            public GulpTask fun(Pair<String, List<String>> pair) {
                return new GulpTask(structure, (String)pair.getFirst(), (List)pair.getSecond());
            }
        });
        structure.setTasks(tasks);
        GulpfileStructure gulpfileStructure = structure;
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createStructure"));
        }
        return gulpfileStructure;
    }

    @NotNull
    private static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile gulpfile, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "newFetchFail"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "newFetchFail"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "newFetchFail"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newFetchFail(gulpfile, GulpService.getInstance(), "gulp", JavaScriptLanguageIcons.BuildTools.Gulp16, message, commandLine, "gulp <list tasks>", executionException, processHandler, processOutput);
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "newFetchFail"));
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    private static ProcessOutput captureTasksFetchOutput(final @NotNull BaseOSProcessHandler processHandler, final boolean jsonOutput) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "captureTasksFetchOutput"));
        }
        final AtomicBoolean taskOutputStarted = new AtomicBoolean(false);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                boolean started;
                String text;
                if (outputType != ProcessOutputTypes.STDERR && outputType != ProcessOutputTypes.SYSTEM && (text = event.getText()) != null && (started = jsonOutput ? StringUtil.containsChar((String)text, (char)'[') || StringUtil.containsChar((String)text, (char)'{') : text.contains("Tasks for"))) {
                    taskOutputStarted.set(true);
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }
        });
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        ProcessOutput output = catcher.getOutput();
        for (int i = 0; i < 300; ++i) {
            if (catcher.run(1000)) {
                ProcessOutput processOutput = output;
                if (processOutput == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "captureTasksFetchOutput"));
                }
                return processOutput;
            }
            if (taskOutputStarted.get()) break;
        }
        if (taskOutputStarted.get()) {
            if (!catcher.run(2000)) {
                catcher.terminateAndWait();
                if (output.getStderr().isEmpty()) {
                    output.setExitCode(0);
                } else {
                    output.setTimeout();
                }
            }
        } else {
            catcher.terminateAndWait();
            output.setTimeout();
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "captureTasksFetchOutput"));
        }
        return processOutput;
    }

    @NotNull
    private static GeneralCommandLine createTasksFetchCommandLine(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String nodeOptions, @NotNull String gulpPackageDir, boolean jsonOutput, @NotNull String gulpfilePath, @NotNull EnvironmentVariablesData envData) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        if (gulpfilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfilePath", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        envData.configureCommandLine(commandLine, true);
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)new File(gulpfilePath).getParentFile(), (boolean)true);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        nodeOptions = nodeOptions.trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        String gulpMainFile = GulpTaskListFetchUtil.formatGulpMainFilePath(gulpPackageDir);
        commandLine.addParameter(gulpMainFile);
        commandLine.addParameter("--no-color");
        commandLine.addParameter("--gulpfile");
        commandLine.addParameter(PathUtil.driveLetterToLowerCase((String)gulpfilePath));
        if (jsonOutput) {
            commandLine.addParameter("--tasks-json");
        } else {
            commandLine.addParameter("--tasks");
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "createTasksFetchCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static String formatGulpMainFilePath(@NotNull String gulpPackageDir) {
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "formatGulpMainFilePath"));
        }
        gulpPackageDir = FileUtil.toSystemDependentName((String)gulpPackageDir);
        String string = StringUtil.trimEnd((String)gulpPackageDir, (String)File.separator) + File.separator + "bin" + File.separator + "gulp.js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil", "formatGulpMainFilePath"));
        }
        return string;
    }
}

