/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunProfileState;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.InetSocketAddress;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration {
    private static final Logger LOG = Logger.getInstance(GulpRunConfiguration.class);
    private GulpRunSettings myRunSettings;

    public GulpRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "<init>"));
        }
        super(project, factory, name);
    }

    public void initializeFields() {
        VirtualFile gulpfile;
        GulpRunSettings runSettings = this.getRunSettings();
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getGulpfilePath()) && (gulpfile = GulpService.getInstance().detectFirstBuildfileInContentRoots(this.getProject(), false)) != null) {
            this.myRunSettings = GulpRunSettings.builder(runSettings).setGulpfilePath(gulpfile.getPath()).build();
        }
    }

    @NotNull
    public GulpRunSettings getRunSettings() {
        if (this.myRunSettings == null) {
            this.myRunSettings = new GulpRunSettings.Builder().build();
        }
        GulpRunSettings gulpRunSettings = this.myRunSettings;
        if (gulpRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getRunSettings"));
        }
        return gulpRunSettings;
    }

    public void setRunSettings(@NotNull GulpRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "setRunSettings"));
        }
        this.myRunSettings = runSettings;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        GulpRunSettings.Builder builder = GulpUtil.readFromXml(this.getProject(), element);
        this.myRunSettings = builder.build();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        GulpRunSettings runSettings = this.myRunSettings;
        if (runSettings != null) {
            GulpUtil.writeToXml(element, this.getRunSettings());
        }
    }

    @Nullable
    private static GulpRunConfiguration getTemplateRunConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getTemplateRunConfiguration"));
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings templateSettings = runManager.getConfigurationTemplate(GulpConfigurationType.getFactory());
        RunConfiguration rc = templateSettings.getConfiguration();
        if (rc instanceof GulpRunConfiguration) {
            return (GulpRunConfiguration)rc;
        }
        LOG.warn("No Gulp.js template run configuration found: " + rc);
        return null;
    }

    @NotNull
    public static GulpRunSettings getTemplateRunSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getTemplateRunSettings"));
        }
        GulpRunConfiguration rc = GulpRunConfiguration.getTemplateRunConfiguration(project);
        if (rc != null) {
            GulpRunSettings gulpRunSettings = rc.getRunSettings();
            if (gulpRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getTemplateRunSettings"));
            }
            return gulpRunSettings;
        }
        GulpRunSettings gulpRunSettings = new GulpRunSettings.Builder().build();
        if (gulpRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getTemplateRunSettings"));
        }
        return gulpRunSettings;
    }

    public static void setTemplateRunSettings(@NotNull Project project, @NotNull GulpRunSettings runSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "setTemplateRunSettings"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "setTemplateRunSettings"));
        }
        GulpRunConfiguration rc = GulpRunConfiguration.getTemplateRunConfiguration(project);
        if (rc != null) {
            rc.setRunSettings(runSettings);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        GulpNonSharedSettings nonSharedSettings = this.getNonSharedSettings();
        GulpUtil.checkConfiguration(this.getProject(), nonSharedSettings, this.getRunSettings());
    }

    @Nullable
    public VirtualFile getGulpfile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getGulpfileSystemIndependentPath());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        GulpRunConfigurationEditor gulpRunConfigurationEditor = new GulpRunConfigurationEditor(this.getProject());
        if (gulpRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getConfigurationEditor"));
        }
        return gulpRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getState"));
        }
        GulpNonSharedSettings nonSharedSettings = this.getNonSharedSettings();
        return new GulpRunProfileState(environment, this.getRunSettings(), nonSharedSettings);
    }

    @NotNull
    private GulpNonSharedSettings getNonSharedSettings() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.getRunSettings().getInterpreterRef().resolve(project);
        GulpNonSharedSettings gulpNonSharedSettings = GulpNonSharedSettingsManager.getInstance(project).get(interpreter, this.getGulpfile());
        if (gulpNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration", "getNonSharedSettings"));
        }
        return gulpNonSharedSettings;
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }
}

