/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myGulpfilePath;
    private final String myGulpfileSystemIndependentPath;
    private final List<String> myTasks;
    private final String myArguments;
    private final EnvironmentVariablesData myEnvData;
    private final boolean myNewEnvFormat;

    public GulpRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myGulpfilePath = FileUtil.toSystemDependentName((String)builder.myGulpfilePath);
        this.myGulpfileSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder.myGulpfilePath);
        this.myTasks = ImmutableList.copyOf((Collection)builder.myTasks);
        this.myArguments = builder.myArguments;
        this.myEnvData = builder.myEnvData;
        this.myNewEnvFormat = builder.myNewEnvFormat;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getNodeOptions"));
        }
        return string;
    }

    @NotNull
    public String getGulpfilePath() {
        String string = this.myGulpfilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getGulpfilePath"));
        }
        return string;
    }

    @NotNull
    public String getGulpfileSystemIndependentPath() {
        String string = this.myGulpfileSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getGulpfileSystemIndependentPath"));
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    public boolean isNewEnvFormat() {
        return this.myNewEnvFormat;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getTasks"));
        }
        return list;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "getArguments"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GulpRunSettings that = (GulpRunSettings)o;
        return this.myEnvData.equals((Object)that.myEnvData) && this.myNodeOptions.equals(that.myNodeOptions) && this.myGulpfilePath.equals(that.myGulpfilePath) && this.myTasks.equals(that.myTasks) && this.myArguments.equals(that.myArguments);
    }

    public int hashCode() {
        int result = this.myGulpfilePath.hashCode();
        result = 31 * result + this.myNodeOptions.hashCode();
        result = 31 * result + this.myTasks.hashCode();
        result = 31 * result + this.myArguments.hashCode();
        result = 31 * result + this.myEnvData.hashCode();
        return result;
    }

    @NotNull
    public static Builder builder(@NotNull GulpRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "builder"));
        }
        Builder builder = new Builder(settings);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myGulpfilePath;
        private List<String> myTasks;
        private String myArguments;
        private EnvironmentVariablesData myEnvData;
        private boolean myNewEnvFormat;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
        }

        public Builder(@NotNull GulpRunSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
            this.myNodeOptions = settings.getNodeOptions();
            this.myGulpfilePath = settings.getGulpfilePath();
            this.myTasks = ImmutableList.copyOf(settings.getTasks());
            this.myEnvData = settings.getEnvData();
            this.myNewEnvFormat = settings.isNewEnvFormat();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@Nullable String nodeOptions) {
            this.myNodeOptions = StringUtil.notNullize((String)nodeOptions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setNodeOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setGulpfilePath(@Nullable String gulpfilePath) {
            this.myGulpfilePath = StringUtil.notNullize((String)gulpfilePath);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setGulpfilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setTasks(@NotNull List<String> tasks) {
            if (tasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setTasks"));
            }
            this.myTasks = ImmutableList.copyOf(tasks);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setTasks"));
            }
            return builder;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setArguments"));
            }
            this.myArguments = arguments;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setArguments"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        public void setNewEnvFormat(boolean newEnvFormat) {
            this.myNewEnvFormat = newEnvFormat;
        }

        @NotNull
        public GulpRunSettings build() {
            GulpRunSettings gulpRunSettings = new GulpRunSettings(this);
            if (gulpRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder", "build"));
            }
            return gulpRunSettings;
        }
    }
}

