/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class GulpWatchTaskListener
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance(GulpWatchTaskListener.class);
    private final Refresher myRefresher = new Refresher();
    private final StringBuilder myBuffer = new StringBuilder();

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        if (outputType != ProcessOutputTypes.SYSTEM && outputType != ProcessOutputTypes.STDERR) {
            this.myBuffer.append(event.getText());
            int startLineInd = 0;
            int endLineInd = StringUtil.indexOf((CharSequence)this.myBuffer, (char)'\n');
            while (endLineInd >= 0) {
                this.processLine(this.myBuffer.substring(startLineInd, endLineInd + 1));
                startLineInd = endLineInd + 1;
                endLineInd = StringUtil.indexOf((CharSequence)this.myBuffer, (char)'\n', (int)startLineInd);
            }
            this.myBuffer.delete(0, startLineInd);
        }
    }

    private void processLine(@NotNull String line) {
        String subString;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpWatchTaskListener", "processLine"));
        }
        if (line.length() > 10 && line.charAt(0) == '[' && line.charAt(9) == ']' && line.regionMatches(10, subString = " Finished '", 0, subString.length())) {
            this.myRefresher.scheduleRefresh(false);
        }
    }

    public void processTerminated(ProcessEvent event) {
        this.myRefresher.scheduleRefresh(true);
    }

    private static class Refresher {
        private final ScheduledExecutorService myExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((int)1);
        private volatile boolean myStopAfterRefresh = false;
        private volatile ScheduledFuture<?> myFuture;

        private Refresher() {
        }

        synchronized void scheduleRefresh(final boolean stopAfterRefresh) {
            if (!this.myStopAfterRefresh) {
                this.myStopAfterRefresh = stopAfterRefresh;
                ScheduledFuture<?> future = this.myFuture;
                if (future != null) {
                    future.cancel(false);
                }
                this.myFuture = this.myExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Refreshing VFS on gulp " + (stopAfterRefresh ? "process termination" : "watch triggering"));
                        LocalFileSystem.getInstance().refresh(true);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

