/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmGlobalSettingsDialog
extends DialogWrapper {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected NpmGlobalSettingsDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmGlobalSettingsDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Npm Settings");
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = NpmRunConfigurationEditor.createNodeOptionsEditor();
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"npm.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
        NpmRunSettings templateRunSettings = NpmRunConfiguration.getTemplateRunSettings(project);
        this.myNodeInterpreterField.setInterpreterRef(templateRunSettings.getInterpreterRef());
        this.myNodeOptionsEditor.setText(templateRunSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(templateRunSettings.getEnvData());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        int minWidth = JBUI.scale((int)300);
        if (this.myNodeInterpreterField.getPreferredSize().width < minWidth) {
            SwingHelper.setPreferredWidth((Component)((Object)this.myNodeInterpreterField), (int)minWidth);
        }
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNodeInterpreterField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String nodeInterpreterError = NodeJsLocalInterpreter.getErrorMessage(this.myNodeInterpreterField.getInterpreter());
        if (nodeInterpreterError != null) {
            return new ValidationInfo(nodeInterpreterError, (JComponent)((Object)this.myNodeInterpreterField));
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        NpmRunSettings templateRunSettings = NpmRunConfiguration.getTemplateRunSettings(this.myProject);
        NpmRunSettings.Builder builder = NpmRunSettings.builder(templateRunSettings);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        NpmRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }
}

