/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NpmRunSettings {
    private static final String TAG_PACKAGE_JSON_PATH = "package-json";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_SCRIPTS = "scripts";
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private final String myPackageJsonSystemIndependentPath;
    private final String myPackageJsonSystemDependentPath;
    private final NpmCommand myCommand;
    private final List<String> myScriptNames;
    private final String myArguments;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final EnvironmentVariablesData myEnvData;

    public NpmRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "<init>"));
        }
        this.myPackageJsonSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder.myPackageJsonPath);
        this.myPackageJsonSystemDependentPath = FileUtil.toSystemDependentName((String)this.myPackageJsonSystemIndependentPath);
        this.myCommand = builder.myCommand;
        this.myScriptNames = builder.myScriptNames;
        this.myArguments = builder.myArguments;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myEnvData = builder.myEnvData;
    }

    @NotNull
    public String getPackageJsonSystemIndependentPath() {
        String string = this.myPackageJsonSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getPackageJsonSystemIndependentPath"));
        }
        return string;
    }

    @NotNull
    public String getPackageJsonSystemDependentPath() {
        String string = this.myPackageJsonSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getPackageJsonSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public NpmCommand getCommand() {
        NpmCommand npmCommand = this.myCommand;
        if (npmCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getCommand"));
        }
        return npmCommand;
    }

    @NotNull
    public List<String> getScriptNames() {
        List<String> list = this.myScriptNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getScriptNames"));
        }
        return list;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getArguments"));
        }
        return string;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getNodeOptions"));
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "builder"));
        }
        return builder;
    }

    @NotNull
    public static Builder builder(@NotNull NpmRunSettings copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "builder"));
        }
        Builder builder = new Builder(copy);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "builder"));
        }
        return builder;
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "writeExternal"));
        }
        if (!this.myPackageJsonSystemIndependentPath.isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_PACKAGE_JSON_PATH, (String)this.myPackageJsonSystemIndependentPath);
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_COMMAND, (String)this.myCommand.getCliOption());
        this.writeScripts(parent);
        if (!this.myArguments.isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_ARGUMENTS, (String)this.myArguments);
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_NODE_INTERPRETER, (String)this.myInterpreterRef.getReferenceName());
        if (!this.myNodeOptions.isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_NODE_OPTIONS, (String)this.myNodeOptions);
        }
        this.myEnvData.writeExternal(parent);
    }

    private void writeScripts(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "writeScripts"));
        }
        if (NpmCommand.RUN_SCRIPT == this.myCommand) {
            Element scriptsElement = new Element(TAG_SCRIPTS);
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)scriptsElement, (String)TAG_SCRIPT, this.myScriptNames);
            parent.addContent(scriptsElement);
        }
    }

    @NotNull
    public static NpmRunSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "readExternal"));
        }
        Builder builder = new Builder();
        builder.setPackageJsonPath(StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_PACKAGE_JSON_PATH)));
        NpmCommand command = NpmCommand.find(JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_COMMAND));
        if (command != null) {
            builder.setCommand(command);
        }
        builder.setScriptNames(NpmRunSettings.readScripts(parent));
        builder.setArguments(StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_ARGUMENTS)));
        String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_NODE_INTERPRETER);
        if (interpreterRefName != null) {
            builder.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        }
        builder.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)parent, (String)TAG_NODE_OPTIONS)));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)parent));
        NpmRunSettings npmRunSettings = builder.build();
        if (npmRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "readExternal"));
        }
        return npmRunSettings;
    }

    @NotNull
    private static List<String> readScripts(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "readScripts"));
        }
        Element tasksElement = parent.getChild(TAG_SCRIPTS);
        if (tasksElement == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "readScripts"));
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)tasksElement, (String)TAG_SCRIPT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings", "readScripts"));
        }
        return list;
    }

    public static class Builder {
        private String myPackageJsonPath;
        private NpmCommand myCommand;
        private List<String> myScriptNames;
        private String myArguments;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private EnvironmentVariablesData myEnvData;

        private Builder() {
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = ImmutableList.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
        }

        private Builder(@NotNull NpmRunSettings copy) {
            if (copy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "<init>"));
            }
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = ImmutableList.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myPackageJsonPath = copy.myPackageJsonSystemIndependentPath;
            this.myCommand = copy.myCommand;
            this.myScriptNames = copy.myScriptNames;
            this.myArguments = copy.myArguments;
            this.myNodeOptions = copy.myNodeOptions;
            this.myEnvData = copy.myEnvData;
        }

        @NotNull
        public Builder setPackageJsonPath(@NotNull String packageJsonPath) {
            if (packageJsonPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonPath", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setPackageJsonPath"));
            }
            this.myPackageJsonPath = packageJsonPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setPackageJsonPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setCommand(@NotNull NpmCommand command) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NpmRunSettings.TAG_COMMAND, "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setCommand"));
            }
            this.myCommand = command;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setCommand"));
            }
            return builder;
        }

        @NotNull
        public Builder setScriptNames(@NotNull List<String> scriptNames) {
            if (scriptNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptNames", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setScriptNames"));
            }
            this.myScriptNames = ImmutableList.copyOf(scriptNames);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setScriptNames"));
            }
            return builder;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NpmRunSettings.TAG_ARGUMENTS, "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setArguments"));
            }
            this.myArguments = arguments;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setArguments"));
            }
            return builder;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@NotNull String nodeOptions) {
            if (nodeOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setNodeOptions"));
            }
            this.myNodeOptions = nodeOptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setNodeOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public NpmRunSettings build() {
            NpmRunSettings npmRunSettings = new NpmRunSettings(this);
            if (npmRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder", "build"));
            }
            return npmRunSettings;
        }
    }
}

