/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSCompletionContributor
extends CompletionContributor {
    private boolean myDoingSmartCodeCompleteAction;
    private PrefixMatcher myPrefixMatcher;
    private CompletionResultSet myCompletionResultSet;
    private Set<String> myAlreadyUsedClassesSet;

    public boolean isDoingSmartCodeCompleteAction() {
        return this.myDoingSmartCodeCompleteAction;
    }

    public PrefixMatcher getPrefixMatcher() {
        return this.myPrefixMatcher;
    }

    public CompletionResultSet getCompletionResultSet() {
        return this.myCompletionResultSet;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        int i;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSCompletionContributor", "fillCompletionVariants"));
        }
        boolean insideJs = JSCompletionContributor.getElementLanguage(parameters).isKindOf((Language)JavascriptLanguage.INSTANCE);
        if (!insideJs) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiReference ref = position.getContainingFile().findReferenceAt(parameters.getOffset());
        if (ref instanceof JSPropertyReference || ref instanceof FileReference) {
            return;
        }
        this.myDoingSmartCodeCompleteAction = parameters.getCompletionType() == CompletionType.SMART;
        this.myAlreadyUsedClassesSet = null;
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        String prefix = prefixMatcher.getPrefix();
        if (ref == null || !(ref.getElement() instanceof JSLiteralExpression)) {
            for (i = prefix.length() - 1; i >= 0 && Character.isJavaIdentifierPart(prefix.charAt(i)); --i) {
            }
            if (i != -1) {
                prefixMatcher = new CamelHumpMatcher(prefix.substring(i + 1));
            }
        }
        this.myPrefixMatcher = prefixMatcher;
        this.myCompletionResultSet = result.withRelevanceSorter(CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh((LookupElementWeigher)new PreferStartMatching()).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSCompletionContributor$1", "weigh"));
                }
                Double d = element instanceof LookupItem ? -((LookupItem)element).getPriority() : (element instanceof PrioritizedLookupElement ? -((PrioritizedLookupElement)element).getPriority() : -0.0);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSCompletionContributor$1", "weigh"));
                }
                return d;
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()));
        this.myCompletionResultSet = this.myCompletionResultSet.withPrefixMatcher(prefixMatcher);
        final JSInsertHandler insertHandler = new JSInsertHandler();
        CompletionService.getCompletionService().getVariantsFromContributors(parameters, (CompletionContributor)this, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult completionResult) {
                LookupItem lookupItem;
                LookupElement item = completionResult.getLookupElement();
                if (item instanceof LookupItem && (lookupItem = (LookupItem)item).getInsertHandler() == null) {
                    lookupItem.setInsertHandler((InsertHandler)insertHandler);
                }
                JSCompletionContributor.this.myCompletionResultSet.withPrefixMatcher(completionResult.getPrefixMatcher()).addElement(item);
            }
        });
        if (position.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA && !(ref instanceof JSDocReference)) {
            String text = position.getText();
            PsiReference[] references = new JSDocReferenceSet(position, text.substring(0, i + 2), 0, true).getReferences();
            List<LookupElement> variants = JSTextReferenceCompletion.addVariants((JSTextReference)references[references.length - 1]);
            this.myCompletionResultSet.addAllElements(variants);
        }
        this.myPrefixMatcher = null;
        this.myAlreadyUsedClassesSet = null;
        this.myDoingSmartCodeCompleteAction = false;
        this.myCompletionResultSet = null;
        result.stopHere();
    }

    public void setAlreadyUsedClassesSet(Set<String> alreadyUsedClassesSet) {
        this.myAlreadyUsedClassesSet = alreadyUsedClassesSet;
    }

    public Set<String> getAlreadyUsedClassesSet() {
        return this.myAlreadyUsedClassesSet;
    }

    private static Language getElementLanguage(CompletionParameters parameters) {
        AccessToken l = ReadAction.start();
        try {
            Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)parameters.getPosition().getContainingFile(), (int)parameters.getOffset());
            return language;
        }
        finally {
            l.finish();
        }
    }

    public static JSCompletionContributor getInstance() {
        return JSCompletionContributorHolder.ourInstance;
    }

    private static class JSCompletionContributorHolder {
        private static final JSCompletionContributor ourInstance;

        private JSCompletionContributorHolder() {
        }

        static {
            JSCompletionContributor instance = null;
            for (CompletionContributor c : CompletionContributor.forLanguage((Language)JavascriptLanguage.INSTANCE)) {
                if (!(c instanceof JSCompletionContributor)) continue;
                instance = (JSCompletionContributor)c;
                break;
            }
            assert (instance != null);
            ourInstance = instance;
        }
    }
}

