/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.JSModuleReference;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final String COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION = "commonjs.complete.required.filename.with.extension";

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        final String fileName = psiFile.getName();
        Condition<String> extensionMatches = new Condition<String>(){

            public boolean value(String s) {
                return StringUtil.endsWithIgnoreCase((String)fileName, (String)s);
            }
        };
        RegistryValue withExtValue = Registry.get((String)COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION);
        if (ContainerUtil.exists((Object[])JSModuleReference.IMPLICIT_EXTENSIONS, (Condition)extensionMatches) && !withExtValue.asBoolean()) {
            String nameWithoutExt = FileUtilRt.getNameWithoutExtension((String)fileName);
            return LookupElementBuilder.create((Object)psiFile, (String)nameWithoutExt).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
        }
        return null;
    }
}

