/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSParameterCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters completionParameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (completionParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionParameters", "com/intellij/lang/javascript/completion/JSParameterCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSParameterCompletionProvider", "addCompletions"));
        }
        PsiElement parent = completionParameters.getPosition().getParent();
        assert (parent instanceof JSParameter);
        JSFunction function = ((JSParameter)parent).getDeclaringFunction();
        if (function instanceof JSFunctionExpression) {
            PsiElement sourceElement;
            JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)function));
            if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl && (sourceElement = type.getSource().getSourceElement()) instanceof JSFunctionItem) {
                String name;
                JSParameterItem[] expectedParameters = ((JSFunctionItem)sourceElement).getParameters();
                JSParameterItemWithSource[] functionParameters = function.getParameters();
                int paramIndex = -1;
                for (int i = 0; i < functionParameters.length; ++i) {
                    if (parent != functionParameters[i]) continue;
                    paramIndex = i;
                    break;
                }
                if (paramIndex == 0 && functionParameters.length == 1 && expectedParameters.length > 0) {
                    StringBuilder parameters = new StringBuilder();
                    for (JSParameterItem expectedParameter : expectedParameters) {
                        if (parameters.length() > 0) {
                            parameters.append(", ");
                        }
                        parameters.append(expectedParameter.getName());
                    }
                    int w = PlatformIcons.PARAMETER_ICON.getIconWidth();
                    LayeredIcon icon = new LayeredIcon(2);
                    icon.setIcon(PlatformIcons.PARAMETER_ICON, 0, 2 * w / 5, 0);
                    icon.setIcon(PlatformIcons.PARAMETER_ICON, 1);
                    result.addElement((LookupElement)LookupElementBuilder.create((Object)sourceElement, (String)parameters.toString()).withIcon((Icon)icon));
                }
                if (paramIndex >= 0 && paramIndex < expectedParameters.length && (name = expectedParameters[paramIndex].getName()) != null) {
                    result.addElement((LookupElement)LookupElementBuilder.create((Object)sourceElement, (String)name).withIcon(PlatformIcons.PARAMETER_ICON));
                }
            }
        }
    }
}

