/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartCompletionContributor {
    public static final LanguageExtension<JSSmartCompletionContributor> EP_NAME = new LanguageExtension("JavaScript.smartCompletionContributor");

    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getSmartCompletionVariants"));
        }
        PsiElement parent = location.getParent();
        JSType expectedClassType = JSTypeUtils.getValuableType(this.findClassType(parent));
        if (expectedClassType instanceof JSNamedType) {
            ArrayList<Object> variants = new ArrayList<Object>();
            String className = expectedClassType.getTypeText();
            LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, className, 101, false, false);
            variants.add(lookupItem);
            JSSmartCompletionContributor.addAllJSClassInheritors(variants, className, parent);
            return variants;
        }
        if (location.getQualifier() == null) {
            if (JSResolveUtil.isExprInJSTypeContext(location)) {
                ArrayList<LookupItem<Object>> variants = new ArrayList<LookupItem<Object>>();
                for (String typeofValue : JSCommonTypeNames.TYPEOF_VALUES) {
                    LookupItem<Object> prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, typeofValue, 101, false, false);
                    variants.add(prioritizedLookupItem);
                }
                return variants;
            }
            return JSSmartCompletionContributor.getStringLiteralVariants((JSExpression)location, true);
        }
        return null;
    }

    @Nullable
    protected static List<LookupElement> getStringLiteralVariants(final @NotNull JSExpression location, final boolean wrapInQuotes) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getStringLiteralVariants"));
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(location);
        if (expectedType != null) {
            final List stringLiteralVariants = ContainerUtil.newSmartList();
            JSTypeUtils.processExpandedType(new Processor<JSType>(){

                public boolean process(JSType type) {
                    if (type instanceof JSStringLiteralTypeImpl) {
                        String literal = ((JSStringLiteralTypeImpl)type).getLiteral();
                        String q = wrapInQuotes ? JSCodeStyleSettings.getQuote((PsiElement)location) : "";
                        LookupItem<Object> prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, q + literal + q, 101, false, false);
                        stringLiteralVariants.add(prioritizedLookupItem);
                    }
                    return true;
                }
            }, expectedType);
            if (!stringLiteralVariants.isEmpty()) {
                return stringLiteralVariants;
            }
        }
        return null;
    }

    private static void addAllJSClassInheritors(List<Object> variants, String className, PsiElement place) {
        final ArrayList all = new ArrayList();
        JSTypeEvaluateManager.iterateSubclasses(place, className, new JSTypeEvaluateManager.NamespaceProcessor(){

            @Override
            public boolean process(String qName, VirtualFile file) {
                all.add(qName);
                return true;
            }
        });
        for (String subclass : all) {
            LookupItem<Object> item = JSLookupUtilImpl.createPrioritizedLookupItem(null, subclass, 101, false, false);
            variants.add(item);
        }
    }

    @Nullable
    protected JSType findClassType(PsiElement parent) {
        IElementType opSign;
        if (parent instanceof JSNewExpression) {
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression && ((opSign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.AS_KEYWORD || opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.INSTANCEOF_KEYWORD)) {
            JSType type = JSResolveUtil.getExpressionJSType(((JSBinaryExpression)parent).getLOperand());
            if (type != null && !(type instanceof JSAnyType) && !(type instanceof JSObjectType)) {
                return type;
            }
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        return null;
    }

    @NotNull
    protected List<Object> addVariantsForUnqualifiedReference(@NotNull JSReferenceExpression location) {
        PsiElement element;
        JSParameterItem param;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
        }
        final JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)location);
        if (expectedType == null) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
            }
            return list;
        }
        PsiElement parent = location.getParent();
        ArrayList<Object> variants = new ArrayList<Object>();
        int qualifiedStaticVariantsStart = Integer.MAX_VALUE;
        PsiElement parentInOriginalTree = PsiUtilCore.getOriginalElement((PsiElement)parent, parent.getClass());
        final CompletionResultSink resultSink = new CompletionResultSink(parentInOriginalTree);
        resultSink.setSmartCompletionInheritanceProcessingContext(JSSmartCompletionVariantsHandler.initProcessingContext(parentInOriginalTree));
        SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(resultSink){
            {
                super(arg0);
                this.setAllowUnqualifiedStaticsFromInstance(true);
                this.setLocalResolve(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$3", "execute"));
                }
                return !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, expectedType, resultSink.getSmartCompletionInheritanceProcessingContext()) || super.execute(element, state);
            }
        };
        JSClass ourClass = JSResolveUtil.getClassOfContext(parentInOriginalTree);
        if (JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            processor.setToProcessHierarchy(true);
            processor.configureClassScope(ourClass);
            JSResolveUtil.treeWalkUp(processor, parentInOriginalTree, parentInOriginalTree.getParent(), parentInOriginalTree);
            processor.setAllowUnqualifiedStaticsFromInstance(false);
            if (expectedType instanceof JSBooleanType) {
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "true", 101, true, true));
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "false", 101, true, true));
            }
        }
        this.processClasses(parentInOriginalTree, processor);
        JSClass clazz = expectedType.resolveClass();
        if (clazz != null && !clazz.isEquivalentTo((PsiElement)ourClass)) {
            qualifiedStaticVariantsStart = ((ResultSink)processor.getResultSink()).getResultCount();
            JSSmartCompletionContributor.processStaticsOf(clazz, processor, ourClass);
        }
        if (ourClass != null && clazz != null && JSInheritanceUtil.isParentClass(ourClass, clazz, false) && !JSResolveUtil.calculateStaticFromContext((PsiElement)location) && JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "this", 101, true, true));
        }
        if (parent instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)location, (JSArgumentList)parent)) instanceof JSParameter && (element = JSResolveUtil.findParent(((JSParameter)param).getParent().getParent())) instanceof JSClass && !element.isEquivalentTo((PsiElement)ourClass) && !element.isEquivalentTo((PsiElement)clazz)) {
            JSSmartCompletionContributor.processStaticsOf((JSClass)element, processor, ourClass);
        }
        int i = 0;
        THashSet used = new THashSet();
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            JSParameterItem parameter;
            String referencedParameterName = null;
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)location, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            for (PsiElement o : results) {
                PsiElement element2;
                JSNamedElement namedElement = (JSNamedElement)o;
                String name = namedElement.getName();
                String additionalPrefix = null;
                if ((namedElement instanceof JSVariable || namedElement instanceof JSFunction) && this.needToQualify(qualifiedStaticVariantsStart, i) && (element2 = JSResolveUtil.findParent((PsiElement)namedElement)) instanceof JSClass) {
                    additionalPrefix = name;
                    name = ((JSClass)element2).getName() + "." + name;
                }
                if (name == null || !used.add(name)) {
                    if (i >= qualifiedStaticVariantsStart) continue;
                    --qualifiedStaticVariantsStart;
                    continue;
                }
                int priority = JSLookupPriority.getSmartVariantPriority(name.equals(referencedParameterName));
                LookupItem<Object> prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)namedElement, name, priority, false, true);
                if (additionalPrefix != null) {
                    prioritizedLookupItem.addLookupStrings(new String[]{additionalPrefix});
                }
                variants.add(prioritizedLookupItem);
                ++i;
            }
        }
        ArrayList<Object> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
        }
        return arrayList;
    }

    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return qualifiedStaticVariantsStart <= i;
    }

    private static void processStaticsOf(JSClass parameterClass, ResolveProcessor processor, @Nullable JSClass contextClass) {
        processor.configureClassScope(contextClass);
        processor.setProcessStatics(true);
        processor.setTypeName(parameterClass.getQualifiedName());
        parameterClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)parameterClass, (PsiElement)parameterClass);
    }

    protected void processClasses(PsiElement parentInOriginalTree, SinkResolveProcessor<?> processor) {
    }
}

