/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.ecmascript6.EcmaScript6CompiledForm;
import com.intellij.lang.javascript.ecmascript6.TraceurCompiler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;

public class CompileEcmaScriptAction
extends AnAction {
    private PsiFile getCurrentFile(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            return (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        }
        return null;
    }

    public void actionPerformed(AnActionEvent actionEvent) {
        final PsiFile es6File = this.getCurrentFile(actionEvent.getDataContext());
        if (es6File != null) {
            final Ref compileCodeRef = new Ref();
            final Ref canceled = new Ref((Object)false);
            Task.Modal task = new Task.Modal(es6File.getProject(), JSBundle.message((String)"es6.compilation.progressbar.message", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/ecmascript6/CompileEcmaScriptAction$1", "run"));
                    }
                    String compiledCode = TraceurCompiler.compile(es6File);
                    compileCodeRef.set((Object)compiledCode);
                }

                public void onCancel() {
                    canceled.set((Object)true);
                }
            };
            ProgressManager.getInstance().run((Task)task);
            if (((Boolean)canceled.get()).booleanValue()) {
                return;
            }
            String fileName = "_Dummy_." + JavaScriptFileType.INSTANCE.getDefaultExtension();
            PsiFile javaScriptFile = compileCodeRef.isNull() ? PsiFileFactory.getInstance((Project)es6File.getProject()).createFileFromText((FileType)PlainTextFileType.INSTANCE, fileName, (CharSequence)JSBundle.message((String)"es6.compilation.error.message", (Object[])new Object[0]), 0, JSBundle.message((String)"es6.compilation.error.message", (Object[])new Object[0]).length()) : PsiFileFactory.getInstance((Project)es6File.getProject()).createFileFromText((FileType)JavaScriptFileType.INSTANCE, fileName, (CharSequence)compileCodeRef.get(), 0, ((String)compileCodeRef.get()).length());
            EcmaScript6CompiledForm compiledCodeForm = new EcmaScript6CompiledForm(es6File.getProject(), es6File, javaScriptFile);
            compiledCodeForm.show();
        }
    }

    public void update(AnActionEvent e) {
        PsiFile psiFile = this.getCurrentFile(e.getDataContext());
        boolean visible = psiFile != null && psiFile.getLanguage() instanceof ECMA6LanguageDialect;
        e.getPresentation().setVisible(visible);
    }
}

