/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.validation.ES6AnnotatingVisitor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModifiersUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.fixes.ReplacePsiElementFix;
import com.intellij.lang.typescript.inspections.TypeScriptAccessibilityCheckInspection;
import com.intellij.lang.typescript.inspections.TypeScriptCheckImportInspection;
import com.intellij.lang.typescript.inspections.TypeScriptUnresolvedFunctionInspection;
import com.intellij.lang.typescript.inspections.TypeScriptUnresolvedVariableInspection;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.validation.TypeScriptFunctionSignatureChecker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    private static final Collection<JSAttributeList.ModifierType> MODIFIERS_KEYWORDS = ContainerUtil.newHashSet((Object[])new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.DECLARE, JSAttributeList.ModifierType.ABSTRACT, JSAttributeList.ModifierType.READONLY});

    public TypeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "<init>"));
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context);
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = provider.getProblemReporter(this.myHolder);
        if (jSAnnotatorProblemReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "createProblemReporter"));
        }
        return jSAnnotatorProblemReporter;
    }

    @Override
    @NotNull
    protected JSTypeChecker<Annotation> createTypeChecker(PsiElement context) {
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context);
        JSTypeChecker<Annotation> jSTypeChecker = provider.getTypeChecker(this.myProblemReporter);
        if (jSTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "createTypeChecker"));
        }
        return jSTypeChecker;
    }

    @Override
    @NotNull
    protected JSFunctionSignatureChecker createFunctionSignatureChecker(PsiElement context) {
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context);
        TypeScriptFunctionSignatureChecker typeScriptFunctionSignatureChecker = provider.getSignatureChecker(this.myTypeChecker, this.myProblemReporter);
        if (typeScriptFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "createFunctionSignatureChecker"));
        }
        return typeScriptFunctionSignatureChecker;
    }

    public void visitComment(PsiComment comment) {
        if (comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            this.checkReferences((PsiElement)comment, null, ProblemHighlightType.ERROR);
            JSFixFactory.getInstance().typeScriptReferencePathValidator().checkReferences(comment, this.myHolder);
        }
    }

    @Override
    protected void checkImplementedMethods(JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        JSAttributeList list = jsClass.getAttributeList();
        if (list != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            return;
        }
        Map<JSNamedElement, JSClass> membersToImplement = TypeScriptUtil.getUnimplementedMembers(jsClass, false);
        if (!membersToImplement.isEmpty()) {
            IntentionAction fix = JSFixFactory.getInstance().typeScriptImplementMethodsFix(jsClass);
            for (Map.Entry<JSNamedElement, JSClass> entry : membersToImplement.entrySet()) {
                JSClass containerClass = entry.getValue();
                String interfaceName = containerClass.getName();
                JSNamedElement memberToImplement = entry.getKey();
                String message = null;
                boolean isFunction = TypeScriptUtil.isTypeScriptMethod((PsiElement)memberToImplement);
                boolean isProperty = TypeScriptUtil.isTypeScriptProperty((PsiElement)memberToImplement);
                if (isFunction || isProperty) {
                    String messageId = isFunction ? (containerClass instanceof TypeScriptClass ? "javascript.validation.message.class.method.not.implemented" : "javascript.validation.message.interface.method.not.implemented") : "javascript.validation.message.interface.property.not.implemented";
                    message = JSBundle.message((String)messageId, (Object[])new Object[]{memberToImplement.getName(), interfaceName});
                } else if (memberToImplement instanceof TypeScriptCallSignature) {
                    message = JSBundle.message((String)"javascript.validation.message.interface.call.signature.not.implemented", (Object[])new Object[]{interfaceName});
                } else if (memberToImplement instanceof TypeScriptIndexSignature) {
                    message = JSBundle.message((String)"javascript.validation.message.interface.index.signature.not.implemented", (Object[])new Object[]{interfaceName});
                }
                assert (message != null);
                this.myProblemReporter.registerProblem(jsClass.getNameIdentifier(), message, ProblemHighlightType.GENERIC_ERROR, fix);
            }
        }
    }

    @Override
    protected void checkSetterReturnType(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "checkSetterReturnType"));
        }
        PsiElement returnTypeElement = function.getReturnTypeElement();
        if (returnTypeElement != null) {
            this.myProblemReporter.registerGenericError(returnTypeElement, JSBundle.message((String)"javascript.validation.message.class.setter.cannot.have.return.type", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    @Override
    protected void checkGetterAndSetterTypeMatch(JSFunction setter, JSFunction getter, JSParameter param, JSType setterType, JSType retType) {
        if ((retType = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(retType))) == null || setterType == null || retType instanceof JSNullType || retType instanceof JSUndefinedType) {
            this.checkAccessorAccessTypeMatch(setter, getter, "javascript.validation.message.set.method.access.type.is.different.from.getter");
            return;
        }
        super.checkGetterAndSetterTypeMatch(setter, getter, param, setterType, retType);
    }

    public void visitTypeScriptIndexSignature(TypeScriptIndexSignature indexSignature) {
        JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
        PsiElement nameElement = indexSignature.getParameterNameElement();
        TypeScriptType parameterType = indexSignature.getParameterType();
        if (nameElement != null) {
            if (parameterType == null) {
                this.myProblemReporter.registerGenericError(nameElement, JSBundle.message((String)"javascript.validation.message.index.no.type", (Object[])new Object[0]), new IntentionAction[0]);
            } else {
                JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
                String parameterTypeText = parameterType.getText();
                if (!TypeScriptIndexSignature.POSSIBLE_TYPES.contains(parameterTypeText)) {
                    this.myProblemReporter.registerGenericError((PsiElement)parameterType, JSBundle.message((String)"javascript.validation.message.index.wrong.type", (Object[])new Object[]{StringUtil.join((Collection)TypeScriptIndexSignature.POSSIBLE_TYPES, (String)", ")}), new IntentionAction[0]);
                }
            }
        }
    }

    public void visitTypeScriptPropertySignature(TypeScriptPropertySignature propertySignature) {
        JSSemanticHighlightingUtil.highlight(propertySignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
        JSSemanticHighlightingUtil.highlight(functionSignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptTypeParameter(TypeScriptTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight(typeParameter, this.myHighlighter, this.myHolder);
    }

    @Override
    protected void addCreateFromUsageFixesForCall(JSCallExpression node, JSReferenceExpression referenceExpression, ResolveResult[] resolveResults, List<LocalQuickFix> quickFixes) {
        String referenceName;
        JSFunction functionByName;
        JSClass context;
        if (!(node instanceof JSNewExpression) && referenceExpression.getQualifier() == null && (context = JSResolveUtil.getClassOfContext((PsiElement)node)) != null && (functionByName = context.findFunctionByName(referenceName = referenceExpression.getReferenceName())) != null) {
            quickFixes.add(new JSInsertThisFix((JSExpression)node));
            return;
        }
        if (referenceExpression.getQualifier() == null && resolveResults.length == 0) {
            quickFixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(referenceExpression));
        }
        super.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
    }

    @Override
    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        String referenceName;
        JSVariable fieldByName;
        JSClass context;
        if (!inTypeContext && node.getQualifier() == null && (context = JSResolveUtil.getClassOfContext((PsiElement)node)) != null && (fieldByName = context.findFieldByName(referenceName = node.getReferenceName())) != null) {
            fixes.add(new JSInsertThisFix((JSExpression)node));
            fixes.add(this.createJSVariableIntentionAction(referenceName, false, false));
            TypeScriptAnnotatingVisitor.addCreateParameterFix(node.getParent(), fixes, referenceName);
            return false;
        }
        if (node.getQualifier() == null && resolveResults.length == 0) {
            fixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node));
        }
        return super.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
    }

    @Override
    protected void checkMissedSuperCall(@Nullable JSFunction constructor, @NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "checkMissedSuperCall"));
        }
        if (constructor instanceof TypeScriptFunction && ((TypeScriptFunction)constructor).isOverloadDeclaration()) {
            return;
        }
        JSAttributeList list = jsClass.getAttributeList();
        if (list != null && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)jsClass)) {
            return;
        }
        super.checkMissedSuperCall(constructor, jsClass);
    }

    @Override
    protected void checkOverriddenMethods(JSClass aClass) {
        JSRecordType aClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(aClass, false, false);
        JSRecordType aClassConstructorType = TypeScriptTypeParser.buildTypeFromClass(aClass, true, false);
        MultiMap checkedMembersInstance = MultiMap.createSet();
        MultiMap checkedMembersConstructor = MultiMap.createSet();
        for (JSClass<?> parentClass : TypeScriptUtil.getNonStrictParents(aClass, aClass instanceof TypeScriptInterface)) {
            if (parentClass == aClass) continue;
            this.checkOverride(aClass, aClassInstanceType, parentClass, false, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersInstance);
            this.checkOverride(aClass, aClassConstructorType, parentClass, true, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersConstructor);
        }
    }

    private void checkOverride(JSClass aClass, JSRecordType aClassType, JSClass parentClass, boolean isStatic, MultiMap<JSRecordType.PropertySignature, JSClass> checkedMembers) {
        JSRecordType parentClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(parentClass, isStatic, false);
        for (JSRecordType.TypeMember parentClassTypeMember : parentClassInstanceType.getTypeMembers()) {
            JSType type;
            JSRecordType.PropertySignature parentClassPropertySignature;
            String name;
            JSRecordType.PropertySignature aClassPropertySignature;
            if (!(parentClassTypeMember instanceof JSRecordType.PropertySignature) || (aClassPropertySignature = aClassType.findPropertySignature(name = (parentClassPropertySignature = (JSRecordType.PropertySignature)parentClassTypeMember).getName())) == null) continue;
            Collection classes = checkedMembers.get((Object)aClassPropertySignature);
            if (!classes.isEmpty()) {
                boolean wasCheckedForHierarchy = false;
                for (JSClass checkedClass : classes) {
                    if (!JSInheritanceUtil.isParentClass(checkedClass, parentClass)) continue;
                    wasCheckedForHierarchy = true;
                    break;
                }
                if (wasCheckedForHierarchy) {
                    continue;
                }
            } else {
                checkedMembers.putValue((Object)aClassPropertySignature, (Object)parentClass);
            }
            if ((type = parentClassPropertySignature.getType()) == null || (type = JSTypeUtils.hasGenericParameter(type) ? TypeScriptUtil.applyGenericsToType(type, aClass, parentClass) : type).isDirectlyAssignableType(aClassPropertySignature.getType(), null)) continue;
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(aClass)) {
                ASTNode nameIdentifier;
                if (!name.equals(classMember.getName())) continue;
                boolean isStaticMember = false;
                if (classMember instanceof JSAttributeListOwner) {
                    JSAttributeList attributeList = ((JSAttributeListOwner)classMember).getAttributeList();
                    boolean bl = isStaticMember = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                if (isStaticMember != isStatic || (nameIdentifier = classMember.findNameIdentifier()) == null) continue;
                this.myProblemReporter.registerGenericError(nameIdentifier, JSBundle.message((String)"javascript.validation.message.incompatible.override", (Object[])new Object[]{parentClass.getName()}), new IntentionAction[0]);
            }
        }
    }

    @Override
    protected boolean needsInitializer(JSParameter parameter) {
        return false;
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "getUnresolvedReferenceHighlightType"));
        }
        if (TypeScriptUtil.resolveIsStrict(node)) {
            return ProblemHighlightType.ERROR;
        }
        return super.getUnresolvedReferenceHighlightType(node);
    }

    @Override
    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "getHighlightTypeForTypeOrSignatureProblem"));
        }
        if (node instanceof JSCallExpression) {
            node = ((JSCallExpression)node).getMethodExpression();
        }
        return node instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)node) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : ProblemHighlightType.GENERIC_ERROR;
    }

    @Override
    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        return true;
    }

    @Override
    protected void checkNotResolvedReferenceListExpression(JSClass jsClass, JSExpression expression, boolean isExtends) {
        if (!jsClass.isInterface() && isExtends) {
            Pair<ES6ReferenceList.Errors, Collection<JSType>> pair = ES6ReferenceListImpl.resolveExpression((PsiElement)expression);
            if (pair.first == ES6ReferenceList.Errors.CIRCLE) {
                this.myTypeChecker.registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.CIRCLE.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                return;
            }
            JSType type = (JSType)ContainerUtil.getFirstItem((Collection)((Collection)pair.second));
            if (type == null || type instanceof JSNullType) {
                return;
            }
            ES6ReferenceList.Errors errorType = (ES6ReferenceList.Errors)pair.first;
            if (errorType == null || errorType == ES6ReferenceList.Errors.NO_CONSTRUCTOR) {
                this.myTypeChecker.registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.NO_CONSTRUCTOR.getString(), (Object[])new Object[]{type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            } else if (errorType == ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS || errorType == ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES) {
                this.myTypeChecker.registerProblem((PsiElement)expression, JSBundle.message((String)errorType.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            } else if (errorType == ES6ReferenceList.Errors.NO_ERROR) {
                JSType item = (JSType)ContainerUtil.getFirstItem((Collection)((Collection)pair.second));
                assert (item != null);
                this.myTypeChecker.registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.IS_NO_CLASS.getString(), (Object[])new Object[]{item.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            }
        }
    }

    @Override
    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        return true;
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            ASTNode requireKeyword;
            ASTNode referenceNode = externalModuleReference.findReferenceNode();
            if (referenceNode != null && StringUtil.unquoteString((String)referenceNode.getText()).endsWith(".ts")) {
                this.myProblemReporter.registerGenericError(referenceNode, JSBundle.message((String)"typescript.validation.module.reference.with.extension", (Object[])new Object[0]), new IntentionAction[0]);
            }
            if ((requireKeyword = externalModuleReference.getNode().findChildByType(JSTokenTypes.REQUIRE_KEYWORD)) != null) {
                JSSemanticHighlightingUtil.highlightKeyword(requireKeyword, this.myHolder);
            }
        }
        for (TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference(); internalModuleReference != null; internalModuleReference = internalModuleReference.getQualifier()) {
            this.checkRefExpression((JSReferenceExpression)internalModuleReference);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    @Override
    protected void checkFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "checkFunctionDeclaration"));
        }
        JSClass parentClass = TypeScriptPsiUtil.getParentClass((PsiElement)node);
        if (parentClass != null) {
            this.validateClassMember(node, parentClass);
        }
        this.validateSignatureFunction(node, parentClass);
        this.validateFunctionReturnTypeElement(node);
        super.checkFunctionDeclaration(node);
    }

    private void validateSignatureFunction(JSFunction node, JSClass parentClass) {
        if (!(node instanceof TypeScriptFunction) || node instanceof JSFunctionExpression) {
            return;
        }
        TypeScriptFunction function = (TypeScriptFunction)node;
        boolean noBody = function.getBody().length == 0;
        boolean isOverload = function.isOverloadDeclaration();
        boolean isAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)function);
        boolean isAmbient = TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function);
        if (noBody && !isOverload && !isAbstract && !isAmbient) {
            ArrayList intentions = ContainerUtil.newArrayList();
            TypeScriptAnnotatingVisitor.addMakeMethodAbstractIntention(parentClass, function, intentions);
            this.myProblemReporter.registerGenericError(function.getNameIdentifier(), JSBundle.message((String)"typescript.validation.message.function.implementation.missing", (Object[])new Object[0]), intentions.toArray(new IntentionAction[intentions.size()]));
            return;
        }
        if (function.isGenerator()) {
            if (isOverload) {
                ASTNode multNode = function.getNode().findChildByType(JSTokenTypes.MULT);
                this.myProblemReporter.registerGenericError(multNode, JSBundle.message((String)"typescript.validation.generators.overload", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            if (isAmbient) {
                ASTNode multNode = function.getNode().findChildByType(JSTokenTypes.MULT);
                this.myProblemReporter.registerGenericError(multNode, JSBundle.message((String)"typescript.validation.generators.ambient", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
        }
        if (isOverload || isAmbient) {
            return;
        }
        List overloadDeclarations = function.getOverloadDeclarations();
        if (overloadDeclarations.size() > 0 && parentClass != null) {
            HashSet abstracts = ContainerUtil.newHashSet();
            if (isAbstract) {
                abstracts.add(function);
            }
            for (TypeScriptFunction declaration : overloadDeclarations) {
                if (!TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)declaration)) continue;
                abstracts.add(declaration);
            }
            if (abstracts.size() != overloadDeclarations.size() + 1) {
                for (TypeScriptFunction anAbstract : abstracts) {
                    JSAttributeList list = anAbstract.getAttributeList();
                    PsiElement element = list != null ? list.findModifierElement(JSAttributeList.ModifierType.ABSTRACT) : null;
                    if (element == null) continue;
                    this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.overload", (Object[])new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static void addMakeMethodAbstractIntention(JSClass parentClass, TypeScriptFunction function, Collection<IntentionAction> intentions) {
        JSAttributeList methodAttributeList;
        JSAttributeList list;
        if (parentClass instanceof TypeScriptClass && parentClass.getAttributeList() != null && (list = parentClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.ABSTRACT) && (methodAttributeList = function.getAttributeList()) != null && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            intentions.add((IntentionAction)JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)function, JSAttributeList.ModifierType.ABSTRACT));
        }
    }

    private void validateClassMember(JSFunction member, JSClass parentClass) {
        PsiElement element;
        JSAttributeList list;
        PsiElement identifier;
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)member) && member.getBody().length > 0 && (identifier = member.getNameIdentifier()) != null) {
            this.myProblemReporter.registerGenericError(identifier, JSBundle.message((String)"javascript.ambient.declaration.should.have.no.body", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if ((list = member.getAttributeList()) != null && (element = list.findModifierElement(JSAttributeList.ModifierType.ABSTRACT)) != null) {
            if (list.getExplicitAccessType() == JSAttributeList.AccessType.PRIVATE) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"private"}), new IntentionAction[0]);
            } else if (list.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"static"}), new IntentionAction[0]);
            }
            if (member.isConstructor()) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.constructor.cannot.be.abstract", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else if (member.getBody().length > 0) {
                this.myProblemReporter.registerGenericError(member.getNameIdentifier(), JSBundle.message((String)"typescript.validation.message.abstract.cannot.have.body", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else {
                JSAttributeList attrList = parentClass.getAttributeList();
                if (attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.class.should.be", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)parentClass, JSAttributeList.ModifierType.ABSTRACT)});
                }
            }
        }
    }

    private static IntentionAction createRemoveAbstractKeywordFix(PsiElement element) {
        return JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.abstract.keyword", element.getNode());
    }

    @Override
    public void visitJSFunctionExpression(JSFunctionExpression node) {
        this.validateFunctionReturnTypeElement((JSFunction)node);
        super.visitJSFunctionExpression(node);
    }

    private void validateFunctionReturnTypeElement(JSFunction function) {
        JSSourceElement[] body;
        PsiElement typeElement = function.getReturnTypeElement();
        JSType returnType = function.getReturnType();
        boolean isGenerator = function.isGenerator();
        if (!(typeElement == null || ES6PsiUtil.isAsyncContext(function) || isGenerator || returnType instanceof JSVoidType || returnType instanceof JSAnyType || (body = function.getBody()).length <= 0 || ControlFlowUtils.elementContainsReturn((JSElement)body[0]) || !(body[0] instanceof JSStatement) || !ControlFlowUtils.statementMayCompleteNormally((JSStatement)body[0]))) {
            this.myProblemReporter.registerGenericError(typeElement, JSBundle.message((String)"javascript.validation.message.return.statement.required", (Object[])new Object[0]), new IntentionAction[0]);
            return;
        }
        if (isGenerator && returnType != null) {
            if (typeElement != null) {
                JSType componentType = JSTypeUtils.getIterableComponentType(returnType);
                if (componentType == null) {
                    this.myTypeChecker.registerProblem(typeElement, JSBundle.message((String)"typescript.validation.generators.incorrect.type.annotation", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(returnType), new LocalQuickFix[0]);
                } else {
                    JSType iterableRawType = JSNamedType.createExplicitlyType("IterableIterator", typeElement);
                    JSGenericTypeImpl iterableIteratorGeneric = new JSGenericTypeImpl(iterableRawType.getSource(), iterableRawType, componentType);
                    if (!returnType.isDirectlyAssignableType((JSType)iterableIteratorGeneric, null)) {
                        this.myTypeChecker.registerProblem(typeElement, JSBundle.message((String)"typescript.validation.generators.incorrect.type.annotation.iterable", (Object[])new Object[]{iterableIteratorGeneric.getTypeText(JSType.TypeTextFormat.PRESENTABLE), returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(returnType), new LocalQuickFix[0]);
                    }
                }
            } else {
                boolean noBody;
                boolean bl = noBody = function.getBody().length == 0;
                if (noBody) {
                    return;
                }
                JSType elementType = returnType instanceof JSGenericTypeImpl ? (JSType)ContainerUtil.getFirstItem(((JSGenericTypeImpl)returnType).getArguments()) : null;
                PsiElement identifier = this.getIdentifierElement(function);
                if (elementType instanceof JSCompositeTypeImpl) {
                    JSType jsType = JSGenericTypesEvaluator.intersectTypes(((JSCompositeTypeImpl)elementType).getTypes());
                    if (jsType == null) {
                        this.myTypeChecker.registerProblem(identifier, JSBundle.message((String)"typescript.validation.generators.no.common", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    }
                } else if ((elementType instanceof JSAnyType || elementType instanceof JSUndefinedType) && !((JSSimpleTypeBaseImpl)elementType).isExplicitlyDeclared()) {
                    this.myTypeChecker.registerProblem(identifier, JSBundle.message((String)"typescript.validation.generators.no.yield", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }
        }
        if (typeElement != null && function.isConstructor() && function.getParent() instanceof JSClass) {
            this.myProblemReporter.registerGenericError(typeElement, JSBundle.message((String)"js.constructor.cant.have.return.type", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    @NotNull
    private PsiElement getIdentifierElement(JSFunction function) {
        PsiElement identifier = null;
        if (function instanceof JSFunctionExpression) {
            JSQualifiedNamedElement to = ((JSFunctionExpression)function).getElementAssignedTo();
            if (to != null) {
                identifier = to.getNameIdentifier();
            }
        } else {
            identifier = function.getNameIdentifier();
        }
        if (identifier == null && function instanceof JSComputedPropertyNameOwner) {
            identifier = ((JSComputedPropertyNameOwner)function).getComputedPropertyName();
        }
        if (identifier == null) {
            identifier = function;
        }
        PsiElement psiElement = identifier;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "getIdentifierElement"));
        }
        return psiElement;
    }

    @Override
    public void visitJSAttributeList(JSAttributeList attributeList) {
        ES6AnnotatingVisitor.highlightAsync(attributeList, this.myHolder);
        this.highlightModifierKeywords(attributeList);
        PsiElement container = attributeList.getParent();
        PsiElement place = TypeScriptPsiUtil.getParentOverDefaultAssignable(container);
        boolean isTopLevel = TypeScriptPsiUtil.isTopLevelContainer(place);
        ASTNode[] children = attributeList.getNode().getChildren(JSTokenTypes.MODIFIERS);
        if (children.length == 0) {
            return;
        }
        HashSet modifiers = ContainerUtil.newHashSet();
        for (ASTNode child : children) {
            IElementType elementType = child.getElementType();
            boolean isAllow = container instanceof JSClass ? TypeScriptModifiersUtil.isAllowClassModifier((JSClass)container, elementType, isTopLevel) : (container instanceof JSVariable || container instanceof JSVarStatement ? TypeScriptModifiersUtil.isAllowVariableModifier(container, elementType, isTopLevel) : (container instanceof JSFunction ? TypeScriptModifiersUtil.isAllowFunctionModifier((JSFunction)container, elementType, isTopLevel) : (container instanceof TypeScriptImportStatement ? TypeScriptModifiersUtil.isAllowImportModifier(container, elementType, isTopLevel) : (container instanceof TypeScriptTypeMember ? TypeScriptModifiersUtil.isAllowTypeSignature((TypeScriptTypeMember)container, elementType, isTopLevel) : TypeScriptModifiersUtil.isAllowCommon(container, elementType, isTopLevel)))));
            if (!isAllow) {
                this.myProblemReporter.registerGenericError(child, TypeScriptModifiersUtil.getModifierErrorMessage(child, isTopLevel), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child)});
                continue;
            }
            if (modifiers.add(child.getElementType())) continue;
            this.myProblemReporter.registerGenericError(child, JSBundle.message((String)"typescript.validation.message.duplicate.modifier", (Object[])new Object[]{child.getText()}), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child)});
        }
        super.visitJSAttributeList(attributeList);
    }

    public void highlightModifierKeywords(JSAttributeList attributeList) {
        for (JSAttributeList.ModifierType modifier : MODIFIERS_KEYWORDS) {
            PsiElement modifierElement = attributeList.findModifierElement(modifier);
            if (modifierElement == null) continue;
            JSSemanticHighlightingUtil.highlightKeyword(modifierElement.getNode(), this.myHolder);
        }
    }

    @Override
    protected void validateRestParameterType(JSParameter parameter) {
        JSType type;
        PsiElement typeElement = parameter.getTypeElement();
        if (typeElement != null && !JSTypeUtils.isArrayType(type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptType)typeElement)))) {
            String newTypeText = new JSArrayTypeImpl(type, type.getSource()).getTypeText(JSType.TypeTextFormat.CODE);
            ReplacePsiElementFix fix = new ReplacePsiElementFix(typeElement, (PsiElement)TypeScriptChangeUtil.createTypeFromText(parameter.getProject(), newTypeText), "typescript.validation.message.unexpected.type.for.rest.parameter.fix");
            this.myProblemReporter.registerGenericError(typeElement, JSBundle.message((String)"typescript.validation.message.unexpected.type.for.rest.parameter", (Object[])new Object[0]), new IntentionAction[0]).registerFix((IntentionAction)fix);
        }
    }

    @Override
    public void visitJSVariable(JSVariable var) {
        PsiElement grandParent = var.getParent().getParent();
        if (grandParent instanceof TypeScriptClass && TypeScriptPsiUtil.isAmbientDeclaration(grandParent) && var.getInitializer() != null) {
            this.myProblemReporter.registerGenericError((PsiElement)var.getInitializer(), JSBundle.message((String)"javascript.ambient.declaration.should.have.no.initializer", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitJSVariable(var);
    }

    public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
        PsiElement parent = exportAssignment.getParent();
        if (parent instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            this.myProblemReporter.registerGenericError(exportAssignment.getNode(), JSBundle.message((String)"typescript.export.assignment.cannot.be.used.in.internal.modules", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptExportAssignment(exportAssignment);
    }

    public void visitTypeScriptModule(TypeScriptModule module) {
        super.visitTypeScriptModule(module);
        ASTNode child = module.getNode().findChildByType(JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS);
        if (child != null) {
            JSSemanticHighlightingUtil.highlightKeyword(child, this.myHolder);
        }
    }

    @Override
    public void visitJSForInStatement(JSForInStatement node) {
        super.visitJSForInStatement(node);
        ES6AnnotatingVisitor.highlightOfKeyword(node, this.myHolder);
    }

    public void visitTypeScriptTypeAlias(TypeScriptTypeAlias typeAlias) {
        super.visitTypeScriptTypeAlias(typeAlias);
        ASTNode typeKeyword = typeAlias.getNode().findChildByType(JSTokenTypes.TYPE_KEYWORD);
        if (typeKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(typeKeyword, this.myHolder);
        }
    }

    public void visitTypeScriptSingleType(TypeScriptSingleType singleType) {
        TypeScriptTypeArgumentList arguments;
        super.visitTypeScriptSingleType(singleType);
        JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
        JSReferenceExpression parent = referenceExpression != null ? referenceExpression : singleType;
        ASTNode typeKeyword = parent.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter);
        if (typeKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(typeKeyword, this.myHolder);
        }
        if ((arguments = singleType.getTypeArguments()) == null || referenceExpression == null) {
            return;
        }
        JSTypeDeclaration[] declarations = arguments.getTypeArguments();
        if (declarations == null || declarations.length <= 0) {
            return;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        String name = StringUtil.notNullize((String)singleType.getQualifiedTypeName());
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!(element instanceof JSClass) && !(element instanceof TypeScriptTypeParameter)) continue;
            if (element instanceof TypeScriptTypeParameterListOwner) {
                TypeScriptTypeParameterList expectedList = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
                if (expectedList != null && expectedList.getTypeParameters().length != 0) continue;
                this.myProblemReporter.registerGenericError((PsiElement)arguments, JSBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), new IntentionAction[0]);
                break;
            }
            this.myProblemReporter.registerGenericError((PsiElement)arguments, JSBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), new IntentionAction[0]);
        }
    }

    @Override
    public void visitES6FromClause(ES6FromClause fromClause) {
        super.visitES6FromClause(fromClause);
        boolean resolve = false;
        PsiReference[] references = fromClause.getReferences();
        ArrayList unresolvedRefs = ContainerUtil.newArrayList();
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)reference).multiResolve(false).length > 0 || reference.resolve() != null) {
                if (reference instanceof FileReference && !((FileReference)reference).isLast()) continue;
                resolve = true;
                continue;
            }
            unresolvedRefs.add(reference);
        }
        if (!resolve && references.length > 0) {
            PsiReference element = (PsiReference)ContainerUtil.getFirstItem((Collection)unresolvedRefs);
            assert (element != null);
            this.registerProblemForReference(element, TypeScriptCheckImportInspection.SHORT_NAME, null, ProblemHighlightType.ERROR);
        }
    }

    @Override
    @Nullable
    protected String getImportCheckInspectionId() {
        return TypeScriptCheckImportInspection.SHORT_NAME;
    }

    @Override
    @Nullable
    protected ProblemHighlightType getImportCheckProblemHighlightType() {
        return ProblemHighlightType.ERROR;
    }

    public void visitTypeScriptTypePredicate(@NotNull TypeScriptTypePredicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "visitTypeScriptTypePredicate"));
        }
        PsiElement parent = predicate.getParent();
        if (!this.checkTypePredicateShouldBeReturnType(predicate, parent)) {
            JSType guardType;
            if ("this".equals(predicate.getParameterName())) {
                return;
            }
            JSParameter parameter = predicate.getParameterMatchName();
            if (parameter == null) {
                PsiElement anchor = predicate.getNameIdentifier();
                if (anchor == null) {
                    anchor = predicate;
                }
                this.myProblemReporter.registerGenericError(anchor.getNode(), JSBundle.message((String)"typescript.type.predicate.not.match.name", (Object[])new Object[]{predicate.getParameterName()}), new IntentionAction[0]);
                return;
            }
            if (parameter.isRest()) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JSBundle.message((String)"typescript.type.predicate.rest", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            PsiElement nameParent = parameter.getParent();
            if (nameParent instanceof JSDestructuringContainer || nameParent instanceof JSDestructuringProperty) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JSBundle.message((String)"typescript.type.predicate.destructuring", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            JSType parameterType = parameter.getType();
            if (parameterType != null && (guardType = predicate.getGuardType()) != null && !parameterType.isDirectlyAssignableType(guardType, null)) {
                this.myProblemReporter.registerGenericError((PsiElement)predicate, JSBundle.message((String)"typescript.type.predicate.incompatible.types", (Object[])new Object[]{parameterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), new IntentionAction[0]);
            }
        }
        super.visitTypeScriptTypePredicate(predicate);
    }

    private boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type, @NotNull Set<PsiElement> visited) {
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "processMethodExpressionResolveResult"));
        }
        if (callExpression instanceof JSNewExpression) {
            if (resolveResult instanceof TypeScriptImportStatement) {
                for (PsiElement element : ((TypeScriptImportStatement)resolveResult).findReferencedElements()) {
                    if (!visited.add(element) || !this.processMethodExpressionResolveResult(callExpression, methodExpression, element, type, visited)) continue;
                    return false;
                }
            } else if (resolveResult instanceof TypeScriptClass) {
                if (this.checkClassInstantiate(callExpression, resolveResult)) {
                    return false;
                }
            } else {
                JSType valuableType = JSTypeUtils.getValuableType(type);
                if (valuableType instanceof JSTypeImpl && ((JSTypeImpl)valuableType).isAbstract()) {
                    this.myProblemReporter.registerGenericError((PsiElement)callExpression, JSBundle.message((String)"typescript.validation.message.abstract.class.be.created", (Object[])new Object[]{valuableType.getTypeText()}), new IntentionAction[0]);
                }
            }
        }
        return super.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type);
    }

    @Override
    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return this.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type, ContainerUtil.newHashSet());
    }

    private boolean checkClassInstantiate(JSCallExpression callExpression, PsiElement resolveResult) {
        if (resolveResult instanceof JSClass) {
            JSClass classElement = (JSClass)resolveResult;
            if (TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)classElement)) {
                this.myProblemReporter.registerGenericError((PsiElement)callExpression, JSBundle.message((String)"typescript.validation.message.abstract.class.be.created", (Object[])new Object[]{classElement.getName()}), new IntentionAction[0]);
                return true;
            }
            if (classElement.isInterface()) {
                this.myProblemReporter.registerGenericError((PsiElement)callExpression, JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), new IntentionAction[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitJSYieldExpression(JSYieldExpression expression) {
        JSType expressionComponentType;
        JSExpression subExpression = expression.getExpression();
        if (subExpression == null) {
            return;
        }
        PsiNamedElement containerParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, TypeScriptModule.class, JSFunction.class, ES7Decorator.class});
        if (containerParent instanceof ES7Decorator || !(containerParent instanceof JSFunction) || !((JSFunction)containerParent).isGenerator()) {
            this.myProblemReporter.registerGenericError((PsiElement)expression, JSBundle.message((String)"typescript.validation.generators.yield.not.in.generator", (Object[])new Object[0]), new IntentionAction[0]);
            return;
        }
        JSTypeEvaluationResult typeResult = JSTypeEvaluator.getExpressionType(subExpression);
        if (expression.isIterable()) {
            JSType expressionType;
            JSType jSType = expressionType = typeResult == null ? null : typeResult.getType();
            if (expressionType == null || !TypeScriptAnnotatingVisitor.validateYieldIterableType(expressionType, expression)) {
                this.myTypeChecker.registerProblem((PsiElement)subExpression, JSBundle.message((String)"typescript.validation.generators.yield.not.iterable", (Object[])new Object[0]), TypeScriptUtil.getProblemHighlightTypeForType(expressionType), new LocalQuickFix[0]);
                return;
            }
            expressionComponentType = JSTypeUtils.getIterableComponentType(expressionType);
        } else {
            expressionComponentType = typeResult == null ? null : typeResult.getType();
        }
        JSFunction function = (JSFunction)containerParent;
        if (function.getReturnTypeElement() == null) {
            return;
        }
        JSType returnType = function.getReturnType();
        if (returnType == null) {
            return;
        }
        JSType componentType = JSTypeUtils.getIterableComponentType(returnType);
        if (componentType != null && expressionComponentType != null && !componentType.isDirectlyAssignableType(expressionComponentType, null)) {
            this.myTypeChecker.registerProblem((PsiElement)subExpression, JSBundle.message((String)"typescript.validation.generators.yield.not.assignable.to.return", (Object[])new Object[]{expressionComponentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), componentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(expressionComponentType), new LocalQuickFix[0]);
        }
    }

    private static boolean validateYieldIterableType(JSType jsType, JSYieldExpression expression) {
        JSType iterableType = JSNamedType.createExplicitlyType("Iterable", (PsiElement)expression);
        JSGenericTypeImpl type = new JSGenericTypeImpl(iterableType.getSource(), iterableType, JSAnyType.get((PsiElement)expression, true));
        return type.isDirectlyAssignableType(jsType, null);
    }

    @Override
    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        JSFunction function;
        JSAttributeList list;
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSSuperExpression && resolved instanceof JSFunction && (list = (function = (JSFunction)resolved).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            this.myProblemReporter.registerGenericError((PsiElement)expression, JSBundle.message((String)"typescript.validation.message.abstract.member.access.super", (Object[])new Object[]{function.getName()}), new IntentionAction[0]);
            return true;
        }
        return false;
    }

    private boolean checkTypePredicateShouldBeReturnType(@NotNull TypeScriptTypePredicate predicate, @NotNull PsiElement parent) {
        boolean isParentCorrectFunction;
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "checkTypePredicateShouldBeReturnType"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "checkTypePredicateShouldBeReturnType"));
        }
        boolean bl = isParentCorrectFunction = parent instanceof TypeScriptFunction && !((TypeScriptFunction)parent).isConstructor() && ((TypeScriptFunction)parent).getReturnTypeElement() == predicate;
        if (isParentCorrectFunction) {
            return false;
        }
        if (predicate.isThisType()) {
            if (parent instanceof JSField && ((JSField)parent).getTypeElement() == predicate) {
                return false;
            }
            this.myProblemReporter.registerGenericError(predicate.getNode(), JSBundle.message((String)"typescript.type.this.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
            return true;
        }
        this.myProblemReporter.registerGenericError(predicate.getNode(), JSBundle.message((String)"typescript.type.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
        return true;
    }

    public void visitTypeScriptTupleType(TypeScriptTupleType tupleType) {
        if (tupleType.getElements().length == 0) {
            this.myProblemReporter.registerGenericError((PsiElement)tupleType, JSBundle.message((String)"typescript.tuple.type.list.cannot.be.empty", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptTupleType(tupleType);
    }

    @Override
    protected Annotation reportUnresolvedFunctionError(PsiElement referenceNameElement, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        return this.reportUnresolvedRefProblem(problemHighlightType, fixes, referenceNameElement, message, TypeScriptUnresolvedFunctionInspection.SHORT_NAME);
    }

    @Override
    protected void reportUnresolvedVariableError(PsiElement identifier, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        this.reportUnresolvedRefProblem(problemHighlightType, fixes, identifier, message, TypeScriptUnresolvedVariableInspection.SHORT_NAME);
    }

    @Override
    protected void reportAccessibilityError(PsiElement identifier, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        this.reportUnresolvedRefProblem(problemHighlightType, fixes, identifier, message, TypeScriptAccessibilityCheckInspection.SHORT_NAME);
    }

    @Override
    public void visitJSPrefixExpression(JSPrefixExpression node) {
        super.visitJSPrefixExpression(node);
        ES6AnnotatingVisitor.highlightAwait(node, this.myHolder);
    }

    @Override
    public void visitJSParameterList(JSParameterList node) {
        boolean hasOptional = false;
        for (JSParameterItemWithSource parameter : node.getCallParameters()) {
            if (hasOptional && !parameter.isOptional() && !parameter.isRest()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter.getSource(), JSBundle.message((String)"javascript.validation.message.parameter.non.optional.after.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            if (parameter.isRest() && parameter.isOptional()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter.getSource(), JSBundle.message((String)"javascript.validation.message.parameter.rest.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            hasOptional = hasOptional || parameter.isOptional();
        }
        super.visitJSParameterList(node);
    }

    @Override
    @Nullable
    protected LocalQuickFix[] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, @Nullable String message) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor", "getQuickFixesForReferenceProblem"));
        }
        if (ref instanceof ES6ImportExportSpecifier && message != null) {
            ResolveResult[] results;
            for (ResolveResult result : results = ((ES6ImportExportSpecifier)ref).multiResolve(false)) {
                if (!(result instanceof JSResolveResult) || ((JSResolveResult)result).getResolveProblemKey() != "javascript.element.need.to.be.included.to.config") continue;
                return JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)ref, result.getElement()).toArray(new LocalQuickFix[0]);
            }
        }
        return super.getQuickFixesForReferenceProblem(ref, message);
    }

    @Override
    protected void addFixesForDistinctResolveProblem(JSReferenceExpression node, List<LocalQuickFix> fixes, String resolveProblemKey, PsiElement element) {
        if (resolveProblemKey == "javascript.element.need.to.be.included.to.config") {
            fixes.addAll(JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)node, element));
        }
        if (resolveProblemKey == "javascript.element.is.not.accessible.message" && element instanceof TypeScriptImportStatement && node.getQualifier() == null) {
            fixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node));
        }
        super.addFixesForDistinctResolveProblem(node, fixes, resolveProblemKey, element);
    }
}

