/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryUtil {
    public static void updateLibrary(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String libraryName, @NotNull Collection<VirtualFile> filesOutOfScope, boolean strictFileList) {
        ScriptingLibraryModel libraryModel;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "updateLibrary"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "updateLibrary"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "updateLibrary"));
        }
        if (filesOutOfScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesOutOfScope", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "updateLibrary"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        Library library = libTable.getLibraryByName(libraryName);
        if (strictFileList && !TypeScriptLibraryUtil.needUpdateFiles(filesOutOfScope, libraryManager, library)) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        if (library != null) {
            ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
            libraryModel = libraryTable.getModel(library);
            if (libraryModel != null) {
                Set oldFiles = libraryModel.getSourceFiles();
                HashSet resultSet = ContainerUtil.newHashSet();
                if (!strictFileList) {
                    for (VirtualFile source : oldFiles) {
                        if (!source.isValid() || scope.accept(source)) continue;
                        resultSet.add(source);
                    }
                }
                resultSet.addAll(filesOutOfScope);
                libraryModel.setSourceFiles(VfsUtilCore.toVirtualFileArray((Collection)resultSet));
            }
        } else {
            if (filesOutOfScope.isEmpty()) {
                return;
            }
            libraryModel = libraryManager.createLibrary(libraryName, VfsUtilCore.toVirtualFileArray(filesOutOfScope), VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PROJECT, false);
        }
        if (libraryModel != null) {
            ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
            if (!mappings.isAssociatedWithProject(libraryName)) {
                mappings.associate(null, libraryName);
            }
            TypeScriptLibraryUtil.configureModules(project, libraryModel, modules);
            libraryManager.commitChanges();
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void configureModules(@NotNull Project project, @NotNull ScriptingLibraryModel libraryModel, @NotNull Collection<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "configureModules"));
        }
        if (libraryModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "configureModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "configureModules"));
        }
        Object[] allModules = ModuleHelper.getModules((Project)project);
        if (allModules.length == 1) {
            return;
        }
        if (libraryModel.isPredefined()) {
            return;
        }
        Set associatedModules = libraryModel.getAssociatedModules();
        if (associatedModules != null && !associatedModules.isEmpty() && associatedModules.containsAll(modules)) {
            return;
        }
        HashSet newModules = ContainerUtil.newHashSet();
        if (associatedModules != null) {
            newModules.addAll(associatedModules);
        }
        if (!modules.isEmpty()) {
            newModules.addAll(modules);
        } else {
            ContainerUtil.addAll((Collection)newModules, (Object[])allModules);
        }
        libraryModel.setAssociatedModules((Set)newModules);
    }

    public static Collection<Module> getModules(@NotNull Project project, @NotNull Collection<VirtualFile> owners) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "getModules"));
        }
        if (owners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owners", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "getModules"));
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        HashSet modules = ContainerUtil.newHashSet();
        for (VirtualFile owner : owners) {
            Module moduleForFile = index.getModuleForFile(owner);
            if (moduleForFile == null) continue;
            modules.add(moduleForFile);
        }
        return modules;
    }

    private static boolean needUpdateFiles(@NotNull Collection<VirtualFile> filesOutOfScope, @NotNull ScriptingLibraryManager libraryManager, @Nullable Library library) {
        if (filesOutOfScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesOutOfScope", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "needUpdateFiles"));
        }
        if (libraryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryManager", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "needUpdateFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (library == null) {
            return !filesOutOfScope.isEmpty();
        }
        ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
        ScriptingLibraryModel libraryModel = libraryTable.getModel(library);
        if (libraryModel == null) {
            return true;
        }
        Set files = libraryModel.getSourceFiles();
        return !files.equals(ContainerUtil.newHashSet(filesOutOfScope));
    }

    public static boolean checkNeedUpdate(@NotNull Project project, @NotNull String libraryName, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "checkNeedUpdate"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "checkNeedUpdate"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/ecmascript6/TypeScriptLibraryUtil", "checkNeedUpdate"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        Library library = libTable.getLibraryByName(libraryName);
        return TypeScriptLibraryUtil.needUpdateFiles(files, libraryManager, library);
    }
}

